<?php

$params = array_merge(
        require(__DIR__ . '/../../common/config/params.php'), require(__DIR__ . '/../../common/config/params-local.php'), require(__DIR__ . '/params.php'), require(__DIR__ . '/params-local.php')
);

return [
    'id' => 'rest-api',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'modules' => [
        'v1' => [
            'class' => 'rest\versions\v1\RestModule'
        ],
        'v2' => [
            'class' => 'rest\versions\v2\RestModule'
        ],
    ],
    'timeZone' => 'America/Los_Angeles',
    'components' => [
        'user' => [
            'class' => 'common\models\User',
            'enableSession' => false,
            'loginUrl' => null,
        ],
        'db' => [
            'class' => 'yii\db\Connection',
            'dsn' => 'mysql:host=localhost;dbname=InPen',
            'username' => 'InPen',
            'password' => 'inP#NL$%L',
            'charset' => 'utf8',
        ],
        'response' => [
            'format' => yii\web\Response::FORMAT_JSON,
            'charset' => 'UTF-8',
        ],
        'log' => [
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'request' => [
            'class' => '\yii\web\Request',
            'enableCookieValidation' => false,
            'parsers' => [
                'application/json' => 'yii\web\JsonParser',
            ],
        ],
        'urlManager' => [
            'enablePrettyUrl' => true,
            'enableStrictParsing' => true,
            'showScriptName' => false,
            'rules' => [
                ['class' => 'yii\rest\UrlRule', 'controller' => [
                        'v1/token',
                        'v1/dose-record'
                    ]
                ],
                'POST v1/token/login' => 'v1/token/login',
                'POST v1/dose-record/save' => 'v1/dose-record/save',
                'POST v1/dose-recommendation/save' => 'v1/dose-recommendation/save',
                'POST v1/application-information/save' => 'v1/application-information/save',
                'POST v1/cartridge-replacement/save' => 'v1/cartridge-replacement/save',
                'POST v1/error-statistics/save' => 'v1/error-statistics/save',
                'POST v1/reminder-occurrence/save' => 'v1/reminder-occurrence/save',
            ],
        ]
    ],
    'aliases' => [
        '@rest' => dirname(__DIR__),
        '@common' => dirname(__DIR__) . "/../common"
    ],
    'params' => $params,
];
