<?php

$params = array_merge(
        require(__DIR__ . '/../../common/config/params.php'), require(__DIR__ . '/../../common/config/params-local.php'), require(__DIR__ . '/params.php'), require(__DIR__ . '/params-local.php')
);

return [
    'id' => 'rest-api',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'modules' => [
        'v1' => [
            'class' => 'rest\versions\v1\RestModule'
        ],
        'v2' => [
            'class' => 'rest\versions\v2\RestModule'
        ],
    ],
    'timeZone' => 'Asia/Calcutta',
    'components' => [
        'user' => [
            'identityClass' => 'common\models\User',
             'enableSession' => false,
            'loginUrl' => null,
        ],
        
        'response' => [
            'format' => yii\web\Response::FORMAT_JSON,
            'charset' => 'UTF-8',
        ],
        'log' => [
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                  'logFile' => '/var/www/html/api/rest/runtime/logs/api.log',
                   //'logFile' => '/home2/Web/api/api/rest/runtime/logs/api.log',
                    
                ],
            ],
        ],
        'request' => [
            'class' => '\yii\web\Request',
            'enableCookieValidation' => false,
            'parsers' => [
                'application/json' => 'yii\web\JsonParser',
            ],
        ],
        'urlManager' => [
            'enablePrettyUrl' => true,
            'enableStrictParsing' => true,
            'showScriptName' => false,
            'rules' => [
                ['class' => 'yii\rest\UrlRule', 'controller' => [
                          'v1/token',
			            'v2/token',
                      'v1/modem'                                         
                    ]
                ],
                
                'POST v1/modem/getconfig' => 'v1/modem/getconfig',
                'POST v1/modem/getconfig1' => 'v1/modem/getconfig1',
                'POST v1/modem/datareceiver' => 'v1/modem/datareceiver',
                'GET v1/modem/getsinglechartdata' => 'v1/modem/getsinglechartdata',
                'GET v1/modem/resetdata' => 'v1/modem/resetdata',
                'GET v1/modem/resetdevicedata' => 'v1/modem/resetdevicedata',
                'GET v1/modem/getalerts' => 'v1/modem/getalerts',
                'GET v1/modem/getgaugedialdata' => 'v1/modem/getgaugedialdata',
                'GET v1/modem/converthtmltopdf' => 'v1/modem/converthtmltopdf',
                'GET v1/modem/generateexel' => 'v1/modem/generateexel',
                'GET v1/modem/senddailyreport' => 'v1/modem/senddailyreport',
                'GET v1/modem/updatedevicestatus' => 'v1/modem/updatedevicestatus',
                            ],
        ]
    ],
    'params' => $params,
];
