<?php

namespace rest\versions\v1\controllers;

use Yii;
use yii\base\ErrorException;
use yii\rest\Controller;
use common\models\User;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Html;
use yii\filters\auth\QueryParamAuth;
use common\components;
use Aws\CognitoIdentityProvider\CognitoIdentityProviderClient;
use Aws\CognitoIdentityProvider\Exception\CognitoIdentityProviderException;
use Exception;
use common\models\UserDailyWeight;
use common\models\UserJennyStar;
use common\models\UserFavoriteExercise;
use common\models\UserMeasurments;
use common\models\UserWater;
/**
* User controller
*/
class UserController extends Controller {

  /**
  * @inheritdoc
  */
  protected function verbs() {
    return [
    'login' => ['POST'],
    ];
  }

  /*Check user registered or not API */
  public function actionCheckregistered() 
  {

    //$model= new User(); 

    //$username =$_SERVER['HTTP_X_MP_USER_EMAIL'];
    //$checkusername =User::findOne(['username' => $username]);
    $checkusername=true;
    if($checkusername){
      $userdata=array("isRegister"=>1,"userType"=>"App");
      $response["error"] = 0;
      $response["successful"] = 1; 
      $response["message"] = "checkRegister";                       
      $response["checkRegister"] = $userdata;
      return $response;

    }else{
      $userdata=array("isRegister"=>0,"userType"=>"Web");
      $response["error"] = 0;
      $response["successful"] = 1; 
      $response["message"] = "checkRegister";                       
      $response["checkRegister"] = $userdata;
      return $response;
    }
        
  }       

  /*calling for signup process */
  public function actionSignup() 
  {

    $model= new User();
    $model_weight= new UserDailyWeight();
    $model_weight1= new UserDailyWeight();
    $value = Yii::$app->request->post();
     
    $currenttime=date('Y-m-d H:i:s');
    $username =$_SERVER['HTTP_X_MP_USER_EMAIL']; 
    $isConfirm = !empty($value['isConfirm']) ? $value['isConfirm'] : '';   
    $firstName = !empty($value['firstName']) ? $value['firstName'] : '';
    $lastName = !empty($value['lastName']) ? $value['lastName'] : '';
    $phone = !empty($value['phone']) ? $value['phone'] : '';
    $jennyid = !empty($value['jennyid']) ? $value['jennyid'] : '';
    $startingWeight = !empty($value['startingWeight']) ? $value['startingWeight'] : '';
    $currentWeight = !empty($value['currentWeight']) ? $value['currentWeight'] : 0;
    $goalWeight = !empty($value['goalWeight']) ? $value['goalWeight'] : '';
    $deviceType = !empty($value['deviceType']) ? $value['deviceType'] : '';
    $deviceToken = !empty($value['deviceToken']) ? $value['deviceToken'] : '';
    $userType = !empty($value['userType']) ? $value['userType'] : '';
    $timeStamp = !empty($value['timeStamp']) ? $value['timeStamp'] : $currenttime;
    $currentdate=explode(" ",$timeStamp);
    $startingWeightDate = !empty($value['startingWeightDate']) ? $value['startingWeightDate'] : $currentdate[0];
    $country = !empty($value['country']) ? $value['country'] : 'USA';
    $purpose = !empty($value['purpose']) ? $value['purpose'] : '';
    $purpose_reminder = !empty($value['purpose_reminder']) ? $value['purpose_reminder'] : 0;
    $motivation = !empty($value['motivation']) ? $value['motivation'] : '';
    $motivation_reminder = !empty($value['motivation_reminder']) ? $value['motivation_reminder'] : 0;
    $newsletter = !empty($value['newsletter']) ? $value['newsletter'] : 0;
    $sonicLogic = isset($value['sonicLogic']) ? $value['sonicLogic'] : 0;

    if($sonicLogic == 1){


      /*registered in case of App*/
    if($isConfirm==true){ 
      $key=Yii::$app->params['key'];
      $secret=Yii::$app->params['secret'];
      $UserPoolId=Yii::$app->params['UserPoolId'];

      try {
        /*$cognitoIdentityProviderClient = CognitoIdentityProviderClient::factory(array(
        'version' => 'latest',
        'region'  => 'us-west-2',    
        'credentials' => array(
          'key'     => $key,
          'secret'  => $secret,
        )
        ));
        $result = $cognitoIdentityProviderClient->adminConfirmSignUp(array(
          'UserPoolId' => $UserPoolId,                      
          'Username'   => $username,
        ));
        $cognitoIdentityProviderClient->adminUpdateUserAttributes([
        'UserAttributes' => [
          [
            'Name' => 'email_verified',
            'Value' => 'true',
          ],
          ],
          'UserPoolId' => $UserPoolId,  
          'Username' => $username,  
        ]);
         */
        $response["error"] = 0;
        $response["successful"] = 1;  
        $response["message"] = "EmailId is verified successfully";

      }catch(Exception $e){                
        if (strpos($e, 'InvalidSignatureException') !== false) {
          $message='Signature not yet current';
        }elseif (strpos($e, 'UserNotFoundException') == true) {
          $message='User does not exist';
        }else{           
        $errorlist=explode("NotAuthorizedException",$e->getMessage());
        $arr = array(',','}','message',':','"');
        $message= str_replace($arr,'',$errorlist[1]);
        }
        $response["error"] = 1;
        $response["successful"] = 0;  
        $response["message"] = $message;
      }

      return $response;
    }else{

      $checkuser = User::findOne(['username' => $username]);
		  if ($checkuser) {
        $response["error"] = 0;
        $response["successful"] = 1;  
        $response["message"] = "Email alreay exist.";
        return $response;
      }
      
      $baseUrl = Yii::$app->params['graphqlurl'];    
      $apiKey = Yii::$app->params['graphqlapikey'];//$headers['x-api-key'];
      
      if( !function_exists('apache_request_headers') ) {
        $headers = $this->apache_request_headers_custom();
      }else{
        $headers = apache_request_headers();
      }
  
      if(isset($headers['AUTHORIZATION']) && $headers['AUTHORIZATION'] !=''){
        $AuthorizationToken = $headers['AUTHORIZATION']; 
      }elseif(isset($headers['authorization']) && $headers['authorization'] !=''){
        $AuthorizationToken = $headers['authorization']; 
      }else{
        $AuthorizationToken = $headers['Authorization']; 
      }
      
      /*registered in case of App*/
      if($userType !='Web'){ 
        
        $model->username=$username;
        $model->first_name=$firstName;
        $model->last_name=$lastName;
        $model->phone=$phone;
        $model->jennyid=$jennyid;
        $model->starting_weight=$startingWeight;
        $model->current_weight=$startingWeight;
        $model->goal_weight=$goalWeight;
        $model->device_type=$deviceType;
        $model->device_token=$deviceToken;
        $model->last_login=$currenttime;
        $model->current_weight_date=$startingWeightDate;
        $model->starting_weight_date=$startingWeightDate;
        $model->goal_weight_date=$currentdate[0];
        $model->user_type='App';
        $model->timestamp=$timeStamp;
        $model->country=$country;
        $model->purpose=$purpose;
        $model->purpose_reminder=$purpose_reminder;
        $model->motivation=$motivation;
        $model->motivation_reminder=$motivation_reminder;
        $model->api_hit_date= date('Y-m-d', strtotime("-1 day"));
        $model->newsletter=$newsletter;
        $model->weight_from='App';
        $model->save(false);

        $lstid=Yii::$app->db->getLastInsertID();
        
        $model_weight1->userId=$lstid;
        $model_weight1->weight=$startingWeight;
        $model_weight1->timeStamp=$startingWeightDate;
        $model_weight1->dataType='App';
        $model_weight1->save(false);

        $response["error"] = 0;
        $response["successful"] = 1;  
        $response["message"] = "Data save Successfully";
        
      }else{ /* registered in case of Web*/
        $currenttime=$timeStamp;;
        $model->username=$username;
        $model->first_name=$firstName;
        $model->last_name=$lastName;
        $model->phone=$phone;        
        $model->jennyid=$jennyid;
        $model->starting_weight=$startingWeight;
        $model->current_weight=$startingWeight;
        $model->goal_weight=$goalWeight;
        $model->device_type=$deviceType;
        $model->device_token=$deviceToken;
        $model->last_login=$currenttime;
        $model->current_weight_date=$startingWeightDate;
        $model->starting_weight_date=$startingWeightDate;
        $model->goal_weight_date=$currentdate[0];
        $model->user_type=$userType;
        $model->timestamp=$timeStamp;
        $model->country=$country;
        $model->purpose=$purpose;
        $model->purpose_reminder=$purpose_reminder;
        $model->motivation=$motivation;
        $model->motivation_reminder=$motivation_reminder;
        $model->api_hit_date= date('Y-m-d', strtotime("-1 day"));
        $model->newsletter=$newsletter;
        $model->weight_from='App';
        $model->save(false);

        $lstid=Yii::$app->db->getLastInsertID();
        
        $model_weight1->userId=$lstid;
        $model_weight1->weight=$startingWeight;
        $model_weight1->timeStamp=$startingWeightDate;
        $model_weight1->dataType='App';
        $model_weight1->save(false);
        
        $response["error"] = 0;
        $response["successful"] = 1;  
        $response["message"] = "Data save Successfully";

      }

      if($response["successful"] == 1){
        
        if($AuthorizationToken!=''){ 
          
          $putProfileInput="";
          $list_ids=Yii::$app->params['list_ids'];

          if($newsletter==1){     
            $phone = substr($phone, -10);
          //$bodyJccustomerprofile='{"query":"mutation PutProfile($putProfileInput: PutProfileInput!){\n putProfile(input: $putProfileInput){\n statusCode,\n success,\n errors\n }\n}","variables":{"putProfileInput": {"first_name": "'.$firstName.'","last_name": "'.$lastName.'","email_id": "'.$username.'","phone_input": {"phone": "'.$phone.'","subscribe": {"country_code": "1","list_ids": "'.$list_ids.'"}}}}}';
          $bodyJccustomerprofile='{"query":"mutation PutProfile($putProfileInput: PutProfileInput!){\n putProfile(input: $putProfileInput){\n response\n }\n}","variables":{"putProfileInput": {"first_name": "'.$firstName.'","last_name": "'.$lastName.'","email_id": "'.$username.'","phone_input": {"phone": "'.$phone.'","subscribe": {"country_code": "1","list_ids": "'.$list_ids.'"}}}}}';  
        }else{
            $bodyJccustomerprofile='{"query":"mutation PutProfile($putProfileInput: PutProfileInput!){\n putProfile(input: $putProfileInput){\n response\n }\n}","variables":{"putProfileInput": {"first_name": "'.$firstName.'","last_name": "'.$lastName.'","email_id": "'.$username.'","phone_input": {"phone": "'.$phone.'"}}}}';
          } 

          $method = 'POST';
          $resultputprofile = UserController::useCurl($apiKey,$baseUrl,$AuthorizationToken,$bodyJccustomerprofile,$method);
          
          $body="{\"query\":\"query GetProfile {getProfile {email_id, last_name,first_name,jenny_id,do_not_email,phone,ep_profile_guid,membership_status(hard_refresh: false),store_profile{lc_start_date,lc_goal_weight,lc_start_weight}}}\"}";
          if($resultputprofile){
            sleep(2);
            $resultGetprofile = UserController::useCurl($apiKey,$baseUrl,$AuthorizationToken,$body,$method);
            $resultGetprofile = json_decode($resultGetprofile,true); 
          }         
          
          //print_r($resultGetprofile);  die('lol');      
          
          $finalResult = $resultGetprofile['data']['getProfile'];
          $goalweightSonic = $resultGetprofile['data']['getProfile']['store_profile']['lc_goal_weight'];
          $startweightSonic = $resultGetprofile['data']['getProfile']['store_profile']['lc_start_weight'];
          $startweightdateSonic = $resultGetprofile['data']['getProfile']['store_profile']['lc_start_date'];
          if($startweightdateSonic)
          $startweightdateSonic = date("Y-m-d", strtotime($startweightdateSonic));
          $phone = $finalResult['phone'];      
          $firstnameSonic = $finalResult['first_name'];
          $lastnameSonic = $finalResult['last_name'];
          $jennyid = $finalResult['jenny_id'];
          $emailid = $finalResult['email_id'];
          $membershipstatus = $finalResult['membership_status'];          
          $goalweightFinal = !empty($goalweightSonic) ? $goalweightSonic : $goalWeight;
          $startweightFinal = !empty($startweightSonic) ? $startweightSonic : $startingWeight;
          $startweightdateFinal = !empty($startweightdateSonic) ? $startweightdateSonic : $startingWeightDate;
          
          
          $checkusername =User::findOne(['username' => $username]);
          if($jennyid){
            $modeluser =User::findOne(['username' => $username]);
            $modeluser->jennyid=$jennyid;
            $modeluser->membership_status=$membershipstatus;
            $modeluser->starting_weight=$startweightFinal;
            $modeluser->starting_weight_date=$startweightdateFinal;
            $modeluser->goal_weight=$goalweightFinal;
            $modeluser->current_weight=$startweightFinal;
            $modeluser->current_weight_date=$startweightdateFinal;
            if($startweightSonic)
            $modeluser->sonic_start_weight = 1;

            if($goalweightSonic)
            $modeluser->sonic_goal_weight = 1;            
            $modeluser->weight_from='Sonic';
            if($checkusername['weight_from']=='App' && $checkusername['sonic_weight_alert']==0)
            $modeluser->sonic_weight_alert=1;

            $checkweightvalue = UserDailyWeight::findOne(['userId' => $lstid,'timeStamp' => $startingWeightDate,'dataType' => 'App']);
            if($checkweightvalue)
              $model_weight2 = UserDailyWeight::findOne(['userId' => $lstid,'timeStamp' => $startingWeightDate,'dataType' => 'App']);
              if($startweightSonic)
                $model_weight2->dataType='Sonic';
            if($startweightdateSonic)
              $model_weight2->timeStamp=$startweightdateSonic;
              $model_weight2->update(false);            
              $modeluser->update(false);
          }
          
                  
        }     

      }      
      return $response;
    }

    }else{

/*registered in case of App*/
if($userType !='Web'){ 
  $key=Yii::$app->params['key'];
  $secret=Yii::$app->params['secret'];
  $UserPoolId=Yii::$app->params['UserPoolId'];

  try {
    /*$cognitoIdentityProviderClient = CognitoIdentityProviderClient::factory(array(
    'version' => 'latest',
    'region'  => 'us-west-2',    
    'credentials' => array(
      'key'     => $key,
      'secret'  => $secret,
    )
    ));
    $result = $cognitoIdentityProviderClient->adminConfirmSignUp(array(
      'UserPoolId' => $UserPoolId,                      
      'Username'   => $username,
    ));
    $cognitoIdentityProviderClient->adminUpdateUserAttributes([
    'UserAttributes' => [
      [
        'Name' => 'email_verified',
        'Value' => 'true',
      ],
      ],
      'UserPoolId' => $UserPoolId,  
      'Username' => $username,  
    ]);
   */
    $model->username=$username;
    $model->first_name=$firstName;
    $model->last_name=$lastName;
    $model->phone=$phone;
    $model->jennyid=$jennyid;
    $model->starting_weight=$startingWeight;
    $model->current_weight=$startingWeight;
    $model->goal_weight=$goalWeight;
    $model->device_type=$deviceType;
    $model->device_token=$deviceToken;
    $model->last_login=$currenttime;
    $model->current_weight_date=$startingWeightDate;
    $model->starting_weight_date=$startingWeightDate;
    $model->goal_weight_date=$currentdate[0];
    $model->user_type='App';
    $model->timestamp=$timeStamp;
    $model->country=$country;
    $model->purpose=$purpose;
    $model->purpose_reminder=$purpose_reminder;
    $model->motivation=$motivation;
    $model->motivation_reminder=$motivation_reminder;
    $model->newsletter=$newsletter;
    //$model->api_hit_date='0000-00-00';
    $model->save(false);

    $lstid=Yii::$app->db->getLastInsertID();
    
    $model_weight1->userId=$lstid;
    $model_weight1->weight=$startingWeight;
    $model_weight1->timeStamp=$startingWeightDate;
    $model_weight1->save(false);
   
    $response["error"] = 0;
    $response["successful"] = 1;  
    $response["message"] = "User Confirmed Successfully";

  }catch(Exception $e){        
    if (strpos($e, 'InvalidSignatureException') !== false) {
      $message='Signature not yet current';
    }else{           
    $errorlist=explode("NotAuthorizedException",$e->getMessage());
    $arr = array(',','}','message',':','"');
    $message= str_replace($arr,'',$errorlist[1]);
    }
    $response["error"] = 1;
    $response["successful"] = 0;  
    $response["message"] = $message;
  }
}else{ /* registered in case of Web*/
  $currenttime=$timeStamp;;
  $model->username=$username;
  $model->first_name=$firstName;
  $model->last_name=$lastName;
  $model->phone=$phone;
  $model->jennyid=$jennyid;
  $model->starting_weight=$startingWeight;
  $model->current_weight=$startingWeight;
  $model->goal_weight=$goalWeight;
  $model->device_type=$deviceType;
  $model->device_token=$deviceToken;
  $model->last_login=$currenttime;
  $model->current_weight_date=$startingWeightDate;
  $model->starting_weight_date=$startingWeightDate;
  $model->goal_weight_date=$currentdate[0];
  $model->user_type=$userType;
  $model->timestamp=$timeStamp;
  $model->country=$country;
  $model->purpose=$purpose;
  $model->purpose_reminder=$purpose_reminder;
  $model->motivation=$motivation;
  $model->motivation_reminder=$motivation_reminder;
  $model->newsletter=$newsletter;
  //$model->api_hit_date='0000-00-00';
  $model->save(false);

  $lstid=Yii::$app->db->getLastInsertID();
 
    $model_weight1->userId=$lstid;
    $model_weight1->weight=$startingWeight;
    $model_weight1->timeStamp=$startingWeightDate;
    $model_weight1->save(false);

   
  $response["error"] = 0;
  $response["successful"] = 1;  
  $response["message"] = "User Confirmed Successfully";

}
return $response;


    }


    
  } 

  /*will call only for old build. for aws confirm-email */
  public function actionConfirmsignup() 
  {

    $model= new User();
    $model_weight= new UserDailyWeight();
    $model_weight1= new UserDailyWeight();
    $value = Yii::$app->request->post();
     
    $currenttime=date('Y-m-d H:i:s');
    $username =$_SERVER['HTTP_X_MP_USER_EMAIL']; 
    $isConfirm = !empty($value['isConfirm']) ? $value['isConfirm'] : '';   
    $firstName = !empty($value['firstName']) ? $value['firstName'] : '';
    $lastName = !empty($value['lastName']) ? $value['lastName'] : '';
    $phone = !empty($value['phone']) ? $value['phone'] : '';
    $jennyid = !empty($value['jennyid']) ? $value['jennyid'] : '';
    $startingWeight = !empty($value['startingWeight']) ? $value['startingWeight'] : '';
    $currentWeight = !empty($value['currentWeight']) ? $value['currentWeight'] : 0;
    $goalWeight = !empty($value['goalWeight']) ? $value['goalWeight'] : '';
    $deviceType = !empty($value['deviceType']) ? $value['deviceType'] : '';
    $deviceToken = !empty($value['deviceToken']) ? $value['deviceToken'] : '';
    $userType = !empty($value['userType']) ? $value['userType'] : '';
    $timeStamp = !empty($value['timeStamp']) ? $value['timeStamp'] : $currenttime;
    $currentdate=explode(" ",$timeStamp);
    $startingWeightDate = !empty($value['startingWeightDate']) ? $value['startingWeightDate'] : $currentdate[0];
    $country = !empty($value['country']) ? $value['country'] : 'USA';
    $purpose = !empty($value['purpose']) ? $value['purpose'] : '';
    $purpose_reminder = !empty($value['purpose_reminder']) ? $value['purpose_reminder'] : 0;
    $motivation = !empty($value['motivation']) ? $value['motivation'] : '';
    $motivation_reminder = !empty($value['motivation_reminder']) ? $value['motivation_reminder'] : 0;
    $newsletter = !empty($value['newsletter']) ? $value['newsletter'] : 0;
    $sonicLogic = isset($value['sonicLogic']) ? $value['sonicLogic'] : 0;

    if($sonicLogic == 1){


      /*registered in case of App*/
    if($isConfirm==true){ 
      $key=Yii::$app->params['key'];
      $secret=Yii::$app->params['secret'];
      $UserPoolId=Yii::$app->params['UserPoolId'];

      try {
        $cognitoIdentityProviderClient = CognitoIdentityProviderClient::factory(array(
        'version' => 'latest',
        'region'  => 'us-west-2',    
        'credentials' => array(
          'key'     => $key,
          'secret'  => $secret,
        )
        ));
        $result = $cognitoIdentityProviderClient->adminConfirmSignUp(array(
          'UserPoolId' => $UserPoolId,                      
          'Username'   => $username,
        ));
        $cognitoIdentityProviderClient->adminUpdateUserAttributes([
        'UserAttributes' => [
          [
            'Name' => 'email_verified',
            'Value' => 'true',
          ],
          ],
          'UserPoolId' => $UserPoolId,  
          'Username' => $username,  
        ]);

        $response["error"] = 0;
        $response["successful"] = 1;  
        $response["message"] = "EmailId is verified successfully";

      }catch(Exception $e){                
        if (strpos($e, 'InvalidSignatureException') !== false) {
          $message='Signature not yet current';
        }elseif (strpos($e, 'UserNotFoundException') == true) {
          $message='User does not exist';
        }else{           
        $errorlist=explode("NotAuthorizedException",$e->getMessage());
        $arr = array(',','}','message',':','"');
        $message= str_replace($arr,'',$errorlist[1]);
        }
        $response["error"] = 1;
        $response["successful"] = 0;  
        $response["message"] = $message;
      }

      return $response;
    }else{

      $checkuser = User::findOne(['username' => $username]);
		  if ($checkuser) {
        $response["error"] = 0;
        $response["successful"] = 1;  
        $response["message"] = "Email alreay exist.";
        return $response;
      }
      
      $baseUrl = Yii::$app->params['graphqlurl'];    
      $apiKey = Yii::$app->params['graphqlapikey'];//$headers['x-api-key'];
      
      if( !function_exists('apache_request_headers') ) {
        $headers = $this->apache_request_headers_custom();
      }else{
        $headers = apache_request_headers();
      }
  
      if(isset($headers['AUTHORIZATION']) && $headers['AUTHORIZATION'] !=''){
        $AuthorizationToken = $headers['AUTHORIZATION']; 
      }elseif(isset($headers['authorization']) && $headers['authorization'] !=''){
        $AuthorizationToken = $headers['authorization']; 
      }else{
        $AuthorizationToken = $headers['Authorization']; 
      }
      
      /*registered in case of App*/
      if($userType !='Web'){ 
        
        $model->username=$username;
        $model->first_name=$firstName;
        $model->last_name=$lastName;
        $model->phone=$phone;
        $model->jennyid=$jennyid;
        $model->starting_weight=$startingWeight;
        $model->current_weight=$startingWeight;
        $model->goal_weight=$goalWeight;
        $model->device_type=$deviceType;
        $model->device_token=$deviceToken;
        $model->last_login=$currenttime;
        $model->current_weight_date=$startingWeightDate;
        $model->starting_weight_date=$startingWeightDate;
        $model->goal_weight_date=$currentdate[0];
        $model->user_type='App';
        $model->timestamp=$timeStamp;
        $model->country=$country;
        $model->purpose=$purpose;
        $model->purpose_reminder=$purpose_reminder;
        $model->motivation=$motivation;
        $model->motivation_reminder=$motivation_reminder;
        $model->api_hit_date= date('Y-m-d', strtotime("-1 day"));
        $model->newsletter=$newsletter;
        $model->weight_from='App';
        $model->save(false);

        $lstid=Yii::$app->db->getLastInsertID();
        
        $model_weight1->userId=$lstid;
        $model_weight1->weight=$startingWeight;
        $model_weight1->timeStamp=$startingWeightDate;
        $model_weight1->dataType='App';
        $model_weight1->save(false);

        $response["error"] = 0;
        $response["successful"] = 1;  
        $response["message"] = "Data save Successfully";
        
      }else{ /* registered in case of Web*/
        $currenttime=$timeStamp;;
        $model->username=$username;
        $model->first_name=$firstName;
        $model->last_name=$lastName;
        $model->phone=$phone;        
        $model->jennyid=$jennyid;
        $model->starting_weight=$startingWeight;
        $model->current_weight=$startingWeight;
        $model->goal_weight=$goalWeight;
        $model->device_type=$deviceType;
        $model->device_token=$deviceToken;
        $model->last_login=$currenttime;
        $model->current_weight_date=$startingWeightDate;
        $model->starting_weight_date=$startingWeightDate;
        $model->goal_weight_date=$currentdate[0];
        $model->user_type=$userType;
        $model->timestamp=$timeStamp;
        $model->country=$country;
        $model->purpose=$purpose;
        $model->purpose_reminder=$purpose_reminder;
        $model->motivation=$motivation;
        $model->motivation_reminder=$motivation_reminder;
        $model->api_hit_date= date('Y-m-d', strtotime("-1 day"));
        $model->newsletter=$newsletter;
        $model->weight_from='App';
        $model->save(false);

        $lstid=Yii::$app->db->getLastInsertID();
        
        $model_weight1->userId=$lstid;
        $model_weight1->weight=$startingWeight;
        $model_weight1->timeStamp=$startingWeightDate;
        $model_weight1->dataType='App';
        $model_weight1->save(false);
        
        $response["error"] = 0;
        $response["successful"] = 1;  
        $response["message"] = "Data save Successfully";

      }

      if($response["successful"] == 1){
        
        if($AuthorizationToken!=''){ 
          
          $putProfileInput="";
          $list_ids=Yii::$app->params['list_ids'];

          if($newsletter==1){     
            $phone = substr($phone, -10);
          //$bodyJccustomerprofile='{"query":"mutation PutProfile($putProfileInput: PutProfileInput!){\n putProfile(input: $putProfileInput){\n statusCode,\n success,\n errors\n }\n}","variables":{"putProfileInput": {"first_name": "'.$firstName.'","last_name": "'.$lastName.'","email_id": "'.$username.'","phone_input": {"phone": "'.$phone.'","subscribe": {"country_code": "1","list_ids": "'.$list_ids.'"}}}}}';
          $bodyJccustomerprofile='{"query":"mutation PutProfile($putProfileInput: PutProfileInput!){\n putProfile(input: $putProfileInput){\n response\n }\n}","variables":{"putProfileInput": {"first_name": "'.$firstName.'","last_name": "'.$lastName.'","email_id": "'.$username.'","phone_input": {"phone": "'.$phone.'","subscribe": {"country_code": "1","list_ids": "'.$list_ids.'"}}}}}';  
        }else{
            $bodyJccustomerprofile='{"query":"mutation PutProfile($putProfileInput: PutProfileInput!){\n putProfile(input: $putProfileInput){\n response\n }\n}","variables":{"putProfileInput": {"first_name": "'.$firstName.'","last_name": "'.$lastName.'","email_id": "'.$username.'","phone_input": {"phone": "'.$phone.'"}}}}';
          } 

          $method = 'POST';
          $resultputprofile = UserController::useCurl($apiKey,$baseUrl,$AuthorizationToken,$bodyJccustomerprofile,$method);
          
          $body="{\"query\":\"query GetProfile {getProfile {email_id, last_name,first_name,jenny_id,do_not_email,phone,ep_profile_guid,membership_status(hard_refresh: false),store_profile{lc_start_date,lc_goal_weight,lc_start_weight}}}\"}";
          if($resultputprofile){
            sleep(2);
            $resultGetprofile = UserController::useCurl($apiKey,$baseUrl,$AuthorizationToken,$body,$method);
            $resultGetprofile = json_decode($resultGetprofile,true); 
          }         
          
          //print_r($resultGetprofile);  die('lol');      
          
          $finalResult = $resultGetprofile['data']['getProfile'];
          $goalweightSonic = $resultGetprofile['data']['getProfile']['store_profile']['lc_goal_weight'];
          $startweightSonic = $resultGetprofile['data']['getProfile']['store_profile']['lc_start_weight'];
          $startweightdateSonic = $resultGetprofile['data']['getProfile']['store_profile']['lc_start_date'];
          if($startweightdateSonic)
          $startweightdateSonic = date("Y-m-d", strtotime($startweightdateSonic));
          $phone = $finalResult['phone'];      
          $firstnameSonic = $finalResult['first_name'];
          $lastnameSonic = $finalResult['last_name'];
          $jennyid = $finalResult['jenny_id'];
          $emailid = $finalResult['email_id'];
          $membershipstatus = $finalResult['membership_status'];          
          $goalweightFinal = !empty($goalweightSonic) ? $goalweightSonic : $goalWeight;
          $startweightFinal = !empty($startweightSonic) ? $startweightSonic : $startingWeight;
          $startweightdateFinal = !empty($startweightdateSonic) ? $startweightdateSonic : $startingWeightDate;
          
          
          $checkusername =User::findOne(['username' => $username]);
          if($jennyid){
            $modeluser =User::findOne(['username' => $username]);
            $modeluser->jennyid=$jennyid;
            $modeluser->membership_status=$membershipstatus;
            $modeluser->starting_weight=$startweightFinal;
            $modeluser->starting_weight_date=$startweightdateFinal;
            $modeluser->goal_weight=$goalweightFinal;
            $modeluser->current_weight=$startweightFinal;
            $modeluser->current_weight_date=$startweightdateFinal;
            if($startweightSonic)
            $modeluser->sonic_start_weight = 1;

            if($goalweightSonic)
            $modeluser->sonic_goal_weight = 1;            
            $modeluser->weight_from='Sonic';
            if($checkusername['weight_from']=='App' && $checkusername['sonic_weight_alert']==0)
            $modeluser->sonic_weight_alert=1;

            $checkweightvalue = UserDailyWeight::findOne(['userId' => $lstid,'timeStamp' => $startingWeightDate,'dataType' => 'App']);
            if($checkweightvalue)
              $model_weight2 = UserDailyWeight::findOne(['userId' => $lstid,'timeStamp' => $startingWeightDate,'dataType' => 'App']);
              if($startweightSonic)
                $model_weight2->dataType='Sonic';
            if($startweightdateSonic)
              $model_weight2->timeStamp=$startweightdateSonic;
              $model_weight2->update(false);            
              $modeluser->update(false);
          }
          
                  
        }     

      }      
      return $response;
    }

    }else{

/*registered in case of App*/
if($userType !='Web'){ 
  $key=Yii::$app->params['key'];
  $secret=Yii::$app->params['secret'];
  $UserPoolId=Yii::$app->params['UserPoolId'];

  try {
    $cognitoIdentityProviderClient = CognitoIdentityProviderClient::factory(array(
    'version' => 'latest',
    'region'  => 'us-west-2',    
    'credentials' => array(
      'key'     => $key,
      'secret'  => $secret,
    )
    ));
    $result = $cognitoIdentityProviderClient->adminConfirmSignUp(array(
      'UserPoolId' => $UserPoolId,                      
      'Username'   => $username,
    ));
    $cognitoIdentityProviderClient->adminUpdateUserAttributes([
    'UserAttributes' => [
      [
        'Name' => 'email_verified',
        'Value' => 'true',
      ],
      ],
      'UserPoolId' => $UserPoolId,  
      'Username' => $username,  
    ]);

    $model->username=$username;
    $model->first_name=$firstName;
    $model->last_name=$lastName;
    $model->phone=$phone;
    $model->jennyid=$jennyid;
    $model->starting_weight=$startingWeight;
    $model->current_weight=$startingWeight;
    $model->goal_weight=$goalWeight;
    $model->device_type=$deviceType;
    $model->device_token=$deviceToken;
    $model->last_login=$currenttime;
    $model->current_weight_date=$startingWeightDate;
    $model->starting_weight_date=$startingWeightDate;
    $model->goal_weight_date=$currentdate[0];
    $model->user_type='App';
    $model->timestamp=$timeStamp;
    $model->country=$country;
    $model->purpose=$purpose;
    $model->purpose_reminder=$purpose_reminder;
    $model->motivation=$motivation;
    $model->motivation_reminder=$motivation_reminder;
    $model->newsletter=$newsletter;
    //$model->api_hit_date='0000-00-00';
    $model->save(false);

    $lstid=Yii::$app->db->getLastInsertID();
    
    $model_weight1->userId=$lstid;
    $model_weight1->weight=$startingWeight;
    $model_weight1->timeStamp=$startingWeightDate;
    $model_weight1->save(false);
   
    $response["error"] = 0;
    $response["successful"] = 1;  
    $response["message"] = "User Confirmed Successfully";

  }catch(Exception $e){        
    if (strpos($e, 'InvalidSignatureException') !== false) {
      $message='Signature not yet current';
    }else{           
    $errorlist=explode("NotAuthorizedException",$e->getMessage());
    $arr = array(',','}','message',':','"');
    $message= str_replace($arr,'',$errorlist[1]);
    }
    $response["error"] = 1;
    $response["successful"] = 0;  
    $response["message"] = $message;
  }
}else{ /* registered in case of Web*/
  $currenttime=$timeStamp;;
  $model->username=$username;
  $model->first_name=$firstName;
  $model->last_name=$lastName;
  $model->phone=$phone;
  $model->jennyid=$jennyid;
  $model->starting_weight=$startingWeight;
  $model->current_weight=$startingWeight;
  $model->goal_weight=$goalWeight;
  $model->device_type=$deviceType;
  $model->device_token=$deviceToken;
  $model->last_login=$currenttime;
  $model->current_weight_date=$startingWeightDate;
  $model->starting_weight_date=$startingWeightDate;
  $model->goal_weight_date=$currentdate[0];
  $model->user_type=$userType;
  $model->timestamp=$timeStamp;
  $model->country=$country;
  $model->purpose=$purpose;
  $model->purpose_reminder=$purpose_reminder;
  $model->motivation=$motivation;
  $model->motivation_reminder=$motivation_reminder;
  $model->newsletter=$newsletter;
  //$model->api_hit_date='0000-00-00';
  $model->save(false);

  $lstid=Yii::$app->db->getLastInsertID();
 
    $model_weight1->userId=$lstid;
    $model_weight1->weight=$startingWeight;
    $model_weight1->timeStamp=$startingWeightDate;
    $model_weight1->save(false);

   
  $response["error"] = 0;
  $response["successful"] = 1;  
  $response["message"] = "User Confirmed Successfully";

}
return $response;


    }


    
  } 


  /*Update setting API */
  public function actionUpdatesetting() 
  {
    $model= new User();

    $value = Yii::$app->request->post();

    $username =$_SERVER['HTTP_X_MP_USER_EMAIL'];
    $keyValue = !empty($value['keyValue']) ? $value['keyValue'] : '';
    $keyName = !empty($value['keyName']) ? $value['keyName'] : '';
    if($keyName=='username')
    $newemail =$_SERVER['HTTP_X_MP_NEW_EMAIL'];

    $checkusername =User::findOne(['username' => $username]);
    if($checkusername){
      $modeluser =User::findOne(['username' => $username]);
      if($keyName=='username')
      $modeluser->username = $newemail;
      if($keyName=='firstName')
      $modeluser->first_name = $keyValue;
      if($keyName=='lastName')
      $modeluser->last_name = $keyValue;
      if($keyName=='phone')
      $modeluser->phone = $keyValue;
      if($keyName=='country')
      $modeluser->country = $keyValue;
      if($keyName=='jennyId')
      $modeluser->jennyid = $keyValue; 
                      
      $modeluser->update(false);

      $response["error"] = 0;
      $response["successful"] = 1;
      $response["message"] = "Updated successfully";
      return $response;
    }else{
      $response["error"] = 1;
      $response["successful"] = 0;
      $response["message"]="User does not exist.";
      return $response;
    }
  } 


  /*Get setting data API */
  public function actionGetsetting() 
  {
    //$model= new User();
    //$username =$_SERVER['HTTP_X_MP_USER_EMAIL'];

    //$sql_select = "select username,first_name ,last_name,phone,jennyid,country from user where username='$username' ";
    //$resuserdata= Yii::$app->db->createCommand($sql_select)->queryone();
    $resuserdata=true;
    if($resuserdata){
     //$resuserdata=array(array("fieldKey"=>"username","fieldValue"=>$resuserdata['username']),array("fieldKey"=>"firstName","fieldValue"=>$resuserdata['first_name']),array("fieldKey"=>"lastName","fieldValue"=>$resuserdata['last_name']));


      $response["error"] = 0;
      $response["successful"] = 1; 
      $response["message"] = "settingData";                       
      $response["settingData"] = [];
      return $response;
    }      
  } 


 public function actionGetsettingnew() 
  {
    $model= new User();
    $username =$_SERVER['HTTP_X_MP_USER_EMAIL'];

    $sql_select = "select username,first_name ,last_name,phone,jennyid,country from user where username='$username' ";
    $resuserdata= Yii::$app->db->createCommand($sql_select)->queryone();

    if($resuserdata){
     $resuserdata=array(array("fieldKey"=>"username","fieldValue"=>$resuserdata['username']),array("fieldKey"=>"firstName","fieldValue"=>$resuserdata['first_name']),array("fieldKey"=>"lastName","fieldValue"=>$resuserdata['last_name']),array("fieldKey"=>"country","fieldValue"=>$resuserdata['country']));


      $response["error"] = 0;
      $response["successful"] = 1; 
      $response["message"] = "settingData";                       
      $response["settingData"] = $resuserdata;
      return $response;
    }      
  }   
  
/*Reset Goal API*/

public function actionResetusergoal() 
{    
  $modeluser= new User();   
  $model_UserFavoriteExercise= new UserFavoriteExercise(); 
  $modelJennyStar= new UserJennyStar();
  $model_weight= new UserDailyWeight();
  $model_weight1= new UserDailyWeight();
  $totalStars=0;
  $value = Yii::$app->request->post();

  $timeStamp = !empty($value['timeStamp']) ? $value['timeStamp'] : '';
  $startingWeight = !empty($value['startingWeight']) ? $value['startingWeight'] : '';
  $currentWeight = !empty($value['currentWeight']) ? $value['currentWeight'] : '';
  $goalWeight = !empty($value['goalWeight']) ? $value['goalWeight'] : '';
  $startingWeightDate = !empty($value['startingWeightDate']) ? $value['startingWeightDate'] : '';
  
  $username =$_SERVER['HTTP_X_MP_USER_EMAIL'];

  $checkusername = User::findOne(['username' => $username]);
  if ($checkusername) {
    $userId=$checkusername['userId'];
    $total_jenny_star=(int)$checkusername['total_jenny_star'];			
  }
  
  $sql_selectjennystar_all = "select * from user_jenny_star where userId=$userId";
  $res_selectjennystar_alls= Yii::$app->db->createCommand($sql_selectjennystar_all)->queryall();

  if($res_selectjennystar_alls){
    foreach($res_selectjennystar_alls as $res_selectjennystar_all){
      $star=0;
      if($res_selectjennystar_all['halfWay']>0)
      $star=10;
      $totalStars += (int)$res_selectjennystar_all['jennyStarMeals']+(int)$res_selectjennystar_all['jennyStarActivity']+(int)$res_selectjennystar_all['jennyStarWeight']+(int)$res_selectjennystar_all['jennyStar']+(int)$res_selectjennystar_all['fastingStar']+(int)$res_selectjennystar_all['mileStone']+$star;

    }
  }    

  $modeluser =User::findOne(['userId' => $userId]);
  $modeluser->starting_weight=$startingWeight;
  $modeluser->goal_weight=$goalWeight;
  $modeluser->current_weight=$startingWeight;
  $modeluser->starting_weight_date=$startingWeightDate;
  $modeluser->total_jenny_star=(int)$totalStars+(int)$total_jenny_star;
  $modeluser->update(false); 

  if($res_selectjennystar_alls){
    foreach($res_selectjennystar_alls as $res_selectjennystar_all){
      $jennyStarId=$res_selectjennystar_all['jennyStarId'];
      $modelJennyStar =UserJennyStar::findOne(['jennyStarId' => $jennyStarId]);
      $modelJennyStar->jennyStarActivity=0;
      $modelJennyStar->jennyStarWeight=0;
      $modelJennyStar->jennyStarMeals=0;
      $modelJennyStar->activityDetail='';
      $modelJennyStar->weightDetail='';
      $modelJennyStar->mealDetail='0 meals tracked';
      $modelJennyStar->colorFlag='Orange';
      $modelJennyStar->halfWay=0;
      $modelJennyStar->mileStone=0;
      $modelJennyStar->jennyStar =0;
      $modelJennyStar->fastingStar =0;
      $modelJennyStar->mileStoneWeightLoss=0;
      $modelJennyStar->spin_left=0;
      $modelJennyStar->message_flag=0;    
      $modelJennyStar->update(false); 
    }
  }    
  
  $sql_delete_daily_weight = "delete from user_daily_weight where userId=$userId";
  Yii::$app->db->createCommand($sql_delete_daily_weight)->execute();

  //$sql_delete_user_jenny_star = "delete from user_jenny_star where userId=$userId";
  //Yii::$app->db->createCommand($sql_delete_user_jenny_star)->execute();

  $sql_delete_user_food_menu = "delete from user_food_menu where userId=$userId";
  Yii::$app->db->createCommand($sql_delete_user_food_menu)->execute();

  $sql_delete_user_food_log = "delete from user_food_log where userId=$userId";
  Yii::$app->db->createCommand($sql_delete_user_food_log)->execute();

  $sql_delete_user_food_log_temp = "delete from user_food_log_temp where userId=$userId";
  Yii::$app->db->createCommand($sql_delete_user_food_log_temp)->execute();

  $sql_delete_foods_details = "delete from foods_details where userId=$userId";
  Yii::$app->db->createCommand($sql_delete_foods_details)->execute();

  $sql_delete_exercise = "delete from exercise where userId=$userId ";
  Yii::$app->db->createCommand($sql_delete_exercise)->execute();

  $sql_delete_user_exercise_log = "delete from user_exercise_log where userId=$userId";
  Yii::$app->db->createCommand($sql_delete_user_exercise_log)->execute();

  $sql_delete_user_rapid_result = "delete from user_rapid_result where userId=$userId";
  Yii::$app->db->createCommand($sql_delete_user_rapid_result)->execute();
  
  $sql_delete_user_measurement_result = "delete from user_measurments where userId=$userId";
  Yii::$app->db->createCommand($sql_delete_user_measurement_result)->execute();

  $sql_delete_user_substitute_menu_result = "delete from user_substitute_menu where userId=$userId";
  Yii::$app->db->createCommand($sql_delete_user_substitute_menu_result)->execute();
  
  $model_UserFavoriteExercise = UserFavoriteExercise::find()->where(['userId' => $userId])->all();
  if($model_UserFavoriteExercise){	
    foreach ($model_UserFavoriteExercise as $model_UserFavoriteExercise1)
    {	
      $rowid=$model_UserFavoriteExercise1['id'];
      $model_UserFavoriteExercise =UserFavoriteExercise::findOne(['id' => $rowid]);
      $model_UserFavoriteExercise->favorite=0;    
      $model_UserFavoriteExercise->update(false); 
    }
          
    $sql_delete_user_favorite_exercise = "delete from user_favorite_exercise where userId=$userId and exerciseId>10";
    Yii::$app->db->createCommand($sql_delete_user_favorite_exercise)->execute();
  } 
   
 
    $model_weight1->userId=$userId;
    $model_weight1->weight=$startingWeight;
    $model_weight1->timeStamp=$startingWeightDate;
    $model_weight1->save(false);      
  
  
  $response["error"] = 0;
  $response["successful"] = 1;
  $response["message"] = "Reset Goal Successfully";							
  
  return $response;         
}  
  
  /*User measerments API */
  public function actionSavemeasurements() 
  {
    $modelMeasurments= new UserMeasurments();
    $modeluser= new User(); 

    $value = Yii::$app->request->post();
    $username =$_SERVER['HTTP_X_MP_USER_EMAIL'];
		$checkusername = User::findOne(['username' => $username]);
		if ($checkusername) {
      $userId=$checkusername['userId'];      			
		}
    $bustchest = !empty($value['bustchest']) ? $value['bustchest'] : '';
    $waist = !empty($value['waist']) ? $value['waist'] : '';
    $abdomen = !empty($value['abdomen']) ? $value['abdomen'] : '';
    $hips = !empty($value['hips']) ? $value['hips'] : '';
    $timeStamp = !empty($value['timeStamp']) ? $value['timeStamp'] : '';

    $checkmeasurments = UserMeasurments::findOne(['userId' => $userId,'timeStamp' => $timeStamp]);
		if ($checkmeasurments) {
			$modelMeasurments = UserMeasurments::findOne(['userId' => $userId,'timeStamp' => $timeStamp]);
			$modelMeasurments->bust_chest=(float)$bustchest;
      $modelMeasurments->waist=(float)$waist;
      $modelMeasurments->abdomen=(float)$abdomen;
      $modelMeasurments->hips=(float)$hips;			
			$modelMeasurments->update(false);	
		}else{
			$modelMeasurments->userId=$userId;
			$modelMeasurments->bust_chest=(float)$bustchest;
      $modelMeasurments->waist=(float)$waist;
      $modelMeasurments->abdomen=(float)$abdomen;
      $modelMeasurments->hips=(float)$hips;	
			$modelMeasurments->timeStamp=$timeStamp;
			$modelMeasurments->save(false);
    }   
    
    
    $response["error"] = 0;
    $response["successful"] = 1;    
    $response["measurementInfo"]=array("bustchest"=>(float)$bustchest,"waist"=>(float)$waist,"abdomen"=>(float)$abdomen,"hips"=>(float)$hips,"timeStamp"=>$timeStamp);
		$response["message"] = "Data saved";							
		
		return $response;         
  }


  public function actionUsermeasurements()  {

    $modeluser= new User(); 

    $value = Yii::$app->request->post();
    $username =$_SERVER['HTTP_X_MP_USER_EMAIL'];
    $timestamp = !empty($value['timeStamp']) ? $value['timeStamp'] : '';
    $checkusername = User::findOne(['username' => $username]);

    $measurementLists1=array();
		$bustchestArr = array();
		$abdomenArr = array();
		$waisttArr = array();
		$hipsArr = array();
    
		if ($checkusername) {
      $userId=$checkusername['userId'];      			
    }
    
    $response["error"] = 0;
    $response["successful"] = 1;

     $sqlUserMeasurment = "SELECT * FROM `user_measurments` WHERE userId = '".$userId."' AND timeStamp = '".$timestamp."'";
		$sqlUserMeasurments= Yii::$app->db->createCommand($sqlUserMeasurment)->queryone();
		
		if($sqlUserMeasurments){
			$response["measurementInfo"]=array("bustchest"=>(float)$sqlUserMeasurments['bust_chest'],"waist"=>(float)$sqlUserMeasurments['waist'],"abdomen"=>(float)$sqlUserMeasurments['abdomen'],"hips"=>(float)$sqlUserMeasurments['hips'],"timeStamp" => $timestamp);
		}
		
		if(!$sqlUserMeasurments){
			$sqlUserMeasurment = "SELECT * FROM `user_measurments` WHERE userId = '".$userId."' AND timeStamp < '".$timestamp."' ORDER BY timeStamp DESC LIMIT 1";
			$sqlUserMeasurments= Yii::$app->db->createCommand($sqlUserMeasurment)->queryone();
			$response["measurementInfo"]=array("bustchest"=>(float)$sqlUserMeasurments['bust_chest'],"waist"=>(float)$sqlUserMeasurments['waist'],"abdomen"=>(float)$sqlUserMeasurments['abdomen'],"hips"=>(float)$sqlUserMeasurments['hips'],"timeStamp" => $sqlUserMeasurments['timeStamp']);
		}

		if(!$sqlUserMeasurments){
			$sqlUserMeasurment = "SELECT * FROM `user_measurments` WHERE userId = '".$userId."' AND timeStamp > '".$timestamp."' ORDER BY timeStamp ASC LIMIT 1";
			$sqlUserMeasurments= Yii::$app->db->createCommand($sqlUserMeasurment)->queryone();
			$response["measurementInfo"]=array("bustchest"=>(float)$sqlUserMeasurments['bust_chest'],"waist"=>(float)$sqlUserMeasurments['waist'],"abdomen"=>(float)$sqlUserMeasurments['abdomen'],"hips"=>(float)$sqlUserMeasurments['hips'],"timeStamp" => $sqlUserMeasurments['timeStamp']);
		}		
		
		if(!$sqlUserMeasurments){
			$response["measurementInfo"]=array("bustchest"=>0,"waist"=>0,"abdomen"=>0,"hips"=>0,"timeStamp" => '');
    }
    
    

    $sql_selectmeasurements = "SELECT * FROM user_measurments WHERE userId=$userId AND (bust_chest !=0 OR waist !=0 OR abdomen !=0 OR hips!=0) ORDER BY timeStamp DESC";
    $resmeasurementLists= Yii::$app->db->createCommand($sql_selectmeasurements)->queryall();
    if(count($resmeasurementLists)> 0){
      foreach($resmeasurementLists AS $measurementvalue){
        $bust_chest=$measurementvalue['bust_chest'];
        $abdomen=$measurementvalue['abdomen'];
        $waist=$measurementvalue['waist'];
        $hips=$measurementvalue['hips'];						
        $measurementLists1[]=array("bustchest"=>(float)$bust_chest,"abdomen"=>(float)$abdomen,"waist"=>(float)$waist,"hips"=>(float)$hips);
      }
    }	
      
    $clengthml=count($measurementLists1);		

    for($x=0;$x<$clengthml;$x++)
    {
      
      if($clengthml >1){
        if($measurementLists1[$x]['bustchest'] !=0){
          $bustchestArr[] = $measurementLists1[$x]['bustchest'];
        }
        
        if($measurementLists1[$x]['abdomen'] !=0){
          $abdomenArr[] = $measurementLists1[$x]['abdomen'];
        }

        if($measurementLists1[$x]['waist'] !=0){
          $waisttArr[] = $measurementLists1[$x]['waist'];
        }

        if($measurementLists1[$x]['hips'] !=0){
          $hipsArr[] = $measurementLists1[$x]['hips'];
        }
      }
      
    }

    $bustchestArrCount = count($bustchestArr); 
    $abdomenArrCount = count($abdomenArr);
    $waisttArrCount = count($waisttArr);
    $hipsArrCount = count($hipsArr);

    if($bustchestArrCount > 1){
      $lostbustchest = round($bustchestArr[$bustchestArrCount-1]-$bustchestArr[0],2);
    }else{
      $lostbustchest = 0;

    }

    if($abdomenArrCount > 1){
      $lostabdomen = round($abdomenArr[$abdomenArrCount-1]-$abdomenArr[0],2);
    }else{
      $lostabdomen = 0;
    }

    if($waisttArrCount > 1){
      $lostwaist = round($waisttArr[$waisttArrCount-1]-$waisttArr[0],2);
    }else{
      $lostwaist = 0;
    }

    if($hipsArrCount > 1){
      $losthips = round($hipsArr[$hipsArrCount-1]-$hipsArr[0],2);
    }else{
      $losthips = 0;
    }

    if($clengthml >1){		
      $totalLostInches=$lostbustchest+$lostabdomen+$lostwaist+$losthips;
      $response["totalLostInches"] = (float)$totalLostInches;	
    }else{
      $response["totalLostInches"] = 0;
    }

    return $response;
           
  }


  public function useCurl($apiKey,$urlLink,$AuthorizationToken,$body,$method){
    $url = $urlLink;
    //$json = json_encode($arrayToSend);
    $json = $body;
    $headers = array();
    $headers[] = 'Content-Type: application/json';
    $headers[] = 'Authorization: '.$AuthorizationToken;
    $headers[] = 'x-api-key: '.$apiKey;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
    curl_setopt($ch, CURLOPT_POST, 1);    
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
  
    //execute post
    $result = curl_exec($ch);
  
    //close connection
    curl_close($ch);
  
    return $result;
  }

   


  /*User measerments API */
  public function actionSavewater() 
  {
    $modelWater= new UserWater();
    $modeluser= new User(); 
    $mtype='';
    $totalquantity=0;
    $newquantity=0;
    $oldquantity=0;
    $message='';

    $value = Yii::$app->request->post();
    $username =$_SERVER['HTTP_X_MP_USER_EMAIL'];
    $checkusername = User::findOne(['username' => $username]);
    if ($checkusername) {
      $userId=$checkusername['userId'];      			
    }
    $quantity = !empty($value['quantity']) ? $value['quantity'] : '';
    $measureType1 = !empty($value['measureType']) ? $value['measureType'] : ''; 
    $isEdit = !empty($value['isEdit']) ? $value['isEdit'] : '';   
    $timeStamp = !empty($value['timeStamp']) ? $value['timeStamp'] : '';
    if($measureType1==0)
    $mtype='oz';
    else
    $mtype='ml';

    if($isEdit==1){
      $checkwater = UserWater::findOne(['userId' => $userId,'timeStamp' => $timeStamp]);
      if ($checkwater) {
        $modelWater = UserWater::findOne(['userId' => $userId,'timeStamp' => $timeStamp]);			
        $modelWater->quantity=(float)$quantity;
        $modelWater->measureType=$mtype;    	
        $modelWater->update(false);	
        $message = "Water Quantity is updated.";
        if($mtype=='oz')
          $mtype='fl oz';
      }else{
        

        $totalquantity=$quantity;
        $measureType=$mtype;
        $modelWater->userId=$userId;
        $modelWater->quantity=(float)$quantity;
        $modelWater->measureType=$mtype;      	
        $modelWater->timeStamp=$timeStamp;
        $modelWater->save(false);
        $message = "Water Quantity is updated.";
        if($mtype=='oz')
          $mtype='fl oz';
        
      }

      $response["error"] = 0;
      $response["successful"] = 1;    
      $response["waterQuantity"]=(float)$quantity.' '.$mtype;
      $response["message"] = $message;


    }else{

      $sql_selectwater = "select * from user_water where userId=$userId and timeStamp='$timeStamp'";
      $sqlgetwater= Yii::$app->db->createCommand($sql_selectwater)->queryone();

      if($sqlgetwater){

        $measureType=$sqlgetwater['measureType'];
        $oldquantity=$sqlgetwater['quantity']; 

        if($measureType == 'oz'){
          $measureTypeflag=1;					
        }else{
          $measureTypeflag=0;
        }             

        if($measureType == 'oz' && $mtype=='ml'){
          $newquantity =round($quantity/29.57,2);        
          $totalquantity=$oldquantity+$newquantity;
        } 
        
        if($measureType == 'oz' && $mtype=='oz'){          
          $totalquantity=$oldquantity+$quantity;
        }

        if($measureType == 'ml' && $mtype=='ml'){          
          $totalquantity=$oldquantity+$quantity;
        }
        
        if($measureType == 'ml' && $mtype=='oz'){
          $newquantity+=round($quantity*29.57,2);        
          $totalquantity=$oldquantity+$newquantity;
        } 
      

        $checkwater = UserWater::findOne(['userId' => $userId,'timeStamp' => $timeStamp]);
        if ($checkwater) {
          $modelWater = UserWater::findOne(['userId' => $userId,'timeStamp' => $timeStamp]);			
          $modelWater->quantity=(float)$totalquantity;        
          $modelWater->update(false);	
          $message = "Water Quantity is added.";
        }
        
      }else{
        $totalquantity=$quantity;
        $measureType=$mtype;
        $modelWater->userId=$userId;
        $modelWater->quantity=(float)$quantity;
        $modelWater->measureType=$mtype;      	
        $modelWater->timeStamp=$timeStamp;
        $modelWater->save(false);
        $message = "Water Quantity is added.";
      }
    

      $response["error"] = 0;
      $response["successful"] = 1;    
      $response["waterQuantity"]=(float)$totalquantity.' '.$measureType;
      $response["message"] = $message;
    }
    
    return $response;         
  }




  /*Update Motivation API */
  public function actionUpdatemotivation(){
    $model= new User();

    $value = Yii::$app->request->post();

    $username =$_SERVER['HTTP_X_MP_USER_EMAIL'];
    $keyValue = !empty($value['keyValue']) ? $value['keyValue'] : '';
    $keyName = !empty($value['keyName']) ? $value['keyName'] : '';
    if($keyName=='username')
    $newemail =$_SERVER['HTTP_X_MP_NEW_EMAIL'];

    $checkusername =User::findOne(['username' => $username]);
    if($checkusername){                 
        if($keyName=='motivation')
          $checkusername->motivation = $keyValue;
          $checkusername->update(false);

      $response["error"] = 0;
      $response["successful"] = 1;
      $response["message"] = "Motivation updated successfully";
        return $response;
    }else{
      $response["error"] = 1;
      $response["successful"] = 0;
      $response["message"]="User does not exist.";
        return $response;
    }
  }



  public function actionUpdateuserslastname(){

    $value = Yii::$app->request->post();
    
    //$username =$_SERVER['HTTP_X_MP_USER_EMAIL'];
    $lastName = !empty($value['lastName']) ? $value['lastName'] : '';
    $lowerlimit = !empty($value['lowerlimit']) ? $value['lowerlimit'] : 0;
    $upperlimt = !empty($value['upperlimt']) ? $value['upperlimt'] : 5;

    $key=Yii::$app->params['key'];
    $secret=Yii::$app->params['secret'];
    $UserPoolId=Yii::$app->params['UserPoolId'];
    

     
    $sql_tmp_users = "SELECT utmp.id, utmp.email AS email , u.username, u.last_name FROM user_temp utmp JOIN user u ON utmp.email = u.username WHERE utmp.process_status =0 and u.last_name !='' ORDER BY utmp.id LIMIT $lowerlimit, $upperlimt";
    
		$res_sql_tmp_users= Yii::$app->db->createCommand($sql_tmp_users)->queryall();

		if($res_sql_tmp_users){
			foreach($res_sql_tmp_users as $reslt){

         $username =  $reslt['email'];
         $lastName =  $reslt['last_name'];
         $id =  $reslt['id'];
       
        $error = 'Error - '.$username;
        $successful = 'Successful - '.$username;
       
       
       
       if($lastName){

        try {
          $cognitoIdentityProviderClient = CognitoIdentityProviderClient::factory(array(
          'version' => 'latest',
          'region'  => 'us-west-2',    
          'credentials' => array(
            'key'     => $key,
            'secret'  => $secret,
          )
          ));
     
          $cognitoIdentityProviderClient->adminUpdateUserAttributes([
          'UserAttributes' => [
            [
              'Name' => 'family_name',
              'Value' => $lastName,
            ],
            ],
            'UserPoolId' => $UserPoolId,  
            'Username' => $username,  
          ]);
  
          $lastName = addslashes($lastName);
          $sql_update_status = "UPDATE user_temp SET process_status = 1, lastname = '".$lastName."' WHERE id =$id";
          Yii::$app->db->createCommand($sql_update_status)->execute();
          
          
            $response[$error] = 0;
            $response[$successful] = 1;  
            $response[$username] = "LastName updated Successfully";  
  
        }catch(Exception $e){
          if (strpos($e, 'InvalidSignatureException') !== false) {
            $message='Signature not yet current';
          }else{           
            $errorlist=explode("NotAuthorizedException",$e->getMessage());
            $arr = array(',','}','message',':','"');
            $message= str_replace($arr,'',$errorlist[1]);
          }
            $response[$error] = 1;
            $response[$successful] = 0;  
            $response[$username] = $message;
        }

       }
      
    }   
  }
    
    
    return $response;
  }

  function apache_request_headers_custom() {
    $arh = array();
    $rx_http = '/\AHTTP_/';
    foreach($_SERVER as $key => $val) {
      if( preg_match($rx_http, $key) ) {
        $arh_key = preg_replace($rx_http, '', $key);
        $rx_matches = array();
        // do some nasty string manipulations to restore the original letter case
        // this should work in most cases
        $rx_matches = explode('_', $arh_key);
        if( count($rx_matches) > 0 and strlen($arh_key) > 2 ) {
          foreach($rx_matches as $ak_key => $ak_val) $rx_matches[$ak_key] = ucfirst($ak_val);
          $arh_key = implode('-', $rx_matches);
        }
        $arh[$arh_key] = $val;
      }
    }
    
    return( $arh );
  
    
  }  
   
}