<?php

namespace rest\versions\v1\controllers;

use Yii;
use yii\base\ErrorException;
use yii\rest\Controller;
use common\models\DeviceMaster;
use common\models\Config;
use common\models\Gateway;
use common\models\QtaConfig;
use common\models\ReadTagConfig;
use common\models\QueryRead;
use common\models\DeviceData;
use common\models\DeviceDataDaily;
use common\models\ConfigApiResponse;
use common\models\ConfigApiStatus;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Html;
use yii\filters\auth\QueryParamAuth;
use common\components;
use kartik\mpdf\Pdf;
use Exception;
use SimpleExcel\SimpleExcel;


/**
 * Modem controller
 */
class ModemController extends Controller
{

  /**
   * @inheritdoc
   */
  protected function verbs()
  {
    return [
      'login' => ['POST'],
    ];
  }

  public function actionResetdata()
  {

    $sql_selectrtd = "TRUNCATE table deviceData";
    $resrtdLists = Yii::$app->db->createCommand($sql_selectrtd)->execute();

    $response["error"] = 0;
    $response["successful"] = 1;
    $response["message"] = "Data Truncated successfully";
    //$response["deviceData"] = $userdata;
    return $response;

  }


  public function actionResetdevicedata()
  {

    date_default_timezone_set("Asia/Calcutta");
    $headers = apache_request_headers();
    //print_r($headers);
    //die();
    $todaydate = date('YmdHis');
    //echo'<BR>'; 
    if ($_SERVER['PHP_AUTH_USER'] == 'dcm@trinity' && $_SERVER['PHP_AUTH_PW'] == 'trinity@1234') {
      $backdate = date('Ymd', strtotime('-24 hours', strtotime($todaydate))) . '000000';

      $sql_selectrtd = "delete from deviceDataDaily where timeStamp < '$backdate'";
      $resrtdLists = Yii::$app->db->createCommand($sql_selectrtd)->execute();
      //die();
      $response["error"] = 0;
      $response["successful"] = 1;
      $response["message"] = "Data Truncated successfully";
      //$response["deviceData"] = $userdata;

    } else {
      $response["error"] = 1;
      $response["successful"] = 0;
      $response["message"] = "You are not Authorized";
    }
    return $response;

  }


  public function actionUpdatedevicestatus()
  {

    date_default_timezone_set("Asia/Calcutta");
    $headers = apache_request_headers();

    //if($_SERVER['PHP_AUTH_USER']=='dcm@trinity' && $_SERVER['PHP_AUTH_PW']=='trinity@1234'){


    $querydevice = "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,d.deviceMasterID,g.gatewayName FROM device d join gateway g join deviceDataDaily dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID";

    $command = Yii::$app->db->createCommand($querydevice);
    $devicedata = $command->queryAll();

    if (count($devicedata) > 0) {
      foreach ($devicedata as $device) {
        $deviceID = $device['deviceID'];
        $gatewayID = $device['gatewayID'];
        $modBusID = $device['modBusID'];

        $querydatanon = "SELECT timeStamp,data,deviceID FROM `deviceData` WHERE deviceID=$modBusID and gatewayID=$gatewayID  order by timeStamp desc limit 0,1";
        $command = Yii::$app->db->createCommand($querydatanon);
        $nonWorkingDevice = $command->queryAll();
        if (count($nonWorkingDevice) > 0) {
          //foreach($nonWorkingDevice as $data){
          //$Now = new DateTime('now', new DateTimeZone('Asia/Calcutta'));
          $date2 = date('YmdHis');
          $diff = abs(strtotime($date2) - strtotime($nonWorkingDevice[0]['timeStamp']));
          $minutscount = floor($diff / 60);

          $last_comunication = $nonWorkingDevice[0]['timeStamp'];
          if ($minutscount > 15) {

            $command = Yii::$app->db->createCommand("update device set isLive=0, lastCommunication='$last_comunication' where modBusID=$modBusID  and gatewayID=$gatewayID");
            $resupdate = $command->execute();
          } else {

            $command = Yii::$app->db->createCommand("update device set isLive=1, lastCommunication='$last_comunication' where modBusID=$modBusID and gatewayID=$gatewayID");
            $resupdate = $command->execute();

          }
        }
      }
    }
    //die();
    $response["error"] = 0;
    $response["successful"] = 1;
    $response["message"] = "Device updated successfully";
    //$response["deviceData"] = $userdata;

    /*}else{
    $response["error"] = 1;
    $response["successful"] = 0; 
    $response["message"] = "You are not Authorized"; 
    } */
    return $response;

  }


  public function actionConverthtmltopdf()
  {

    //require_once('/var/www/html/api/vendor/faisalman/simple-excel-php/src/SimpleExcel/SimpleExcel.php'); // load the main class file (if you're not using autoloader)
    //require_once('../../../../autoload.php');
    try {
      $content = '<html>
      <head>
      <link href="style.css" type="text/css" rel="stylesheet"/>
      </head>
      <body>
      <div id="wrapper">
      
      <div id="html_div">
       <form action="generate_pdf.php" method="post">
        <input type="text" name="name" placeholder="Enter Name">
        <br>
        <input type="text" name="email" placeholder="Enter Email">
        <br>
        <input type="text" name="age" placeholder="Enter Age">
        <br>
        <input type="text" name="country" placeholder="Enter Country">
        <br>
        <input type="submit" name="submit_val" value="GENERATE PDF">
       </form>
      </div>
      
      </div>
      </body>
      </html>'; //$this->renderPartial('_reportView');


      // setup kartik\mpdf\Pdf component
      $pdf = new Pdf([
        // set to use core fonts only
        'mode' => Pdf::MODE_CORE,
        // A4 paper format
        'format' => Pdf::FORMAT_A4,
        // portrait orientation
        'orientation' => Pdf::ORIENT_PORTRAIT,
        // stream to browser inline
        'destination' => Pdf::DEST_BROWSER,
        // your html content input
        'content' => $content,
        // format content from your own css file if needed or use the
        // enhanced bootstrap css built by Krajee for mPDF formatting 
        //'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
        'cssFile' => '',
        // any css to be embedded if required
        'cssInline' => '.kv-heading-1{font-size:18px}',
        // set mPDF properties on the fly
        'options' => ['title' => 'Krajee Report Title'],
        // call mPDF methods on the fly
        'methods' => [
          'SetHeader' => ['Krajee Report Header'],
          'SetFooter' => ['{PAGENO}'],
        ]
      ]);
      echo $pdf->render();


    } catch (Exception $e) {
      //echo 'Message: ' .$e->getMessage();
      $response["error"] = 1;
      $response["successful"] = 0;
      $response["message"] = $e->getMessage();
      return $response;
    }


  }


  public function actionSenddailyreport()
  {


    $queryautoreport = "SELECT * from autoReports";
    $command = Yii::$app->db->createCommand($queryautoreport);
    $deviceautoreport = $command->queryAll();
    $todaydate='';

    foreach ($deviceautoreport as $autoreport) {
      $autoReportTime = $autoreport['autoReportTime'];

      $emailid = $autoreport['autoReportEmails'];
      $autoReportSubject = $autoreport['autoReportSubject'];
      $autoReportType = $autoreport['autoReportType'];
      $mailsenddata = date("H:i");
      if ($mailsenddata == $autoReportTime) {
        $todateDate = date("Ymd");
        $prev_date = date('Ymd', strtotime($todateDate .' -1 day'));
        if($autoReportType==1){
        $fromdate=$prev_date.'000000';
        $todate=$prev_date.'235900';
        $timely='Daily';
        $todaydate = date('d M Y', strtotime($todateDate));
        }else if($autoReportType==2){
        $fromdate = date("Ym").'01000000';
        $todate=$prev_date.'235900';
        $todaydate = date('M Y', strtotime($todateDate));
        $timely='Monthly';
        }
        $querydeviceval = "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,d.deviceMasterID,g.gatewayName FROM device d join gateway g join deviceData dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and d.isLive=1";
        $command = Yii::$app->db->createCommand($querydeviceval);
        $deviceProvider = $command->queryAll();

        $html = "<html><body><table><td colspan='2' style='padding:10px 0'><h2 style='font-size:20px;padding:0;margin:20px 0 0 0;font-weight:bold;font-family:Arial'>" . $timely . " Consumption report for <span style='color:red'>" . $todaydate . "</span> - " . $autoReportSubject . "</h2><br>";

        foreach ($deviceProvider as $deviceval) {
          $gatewayID = $deviceval['gatewayID'];
          $modBusID = $deviceval['modBusID'];
          //$mapMasterID=$deviceval['mapMasterID'];


          $querydata = "SELECT  deviceID,max(data) as maxdata ,min(data) as mindata,timeStamp,mapMasterID FROM deviceDataDaily where deviceID =$modBusID and gatewayID=$gatewayID and mapMasterID in(3,6,7,308,309) and timeStamp between '$fromdate' and '$todate' group by mapMasterID";
          $command = Yii::$app->db->createCommand($querydata);
          $devicequerydata = $command->queryAll();
          if (count($devicequerydata) > 0) {
            $averagepf=(round($devicequerydata[1]['maxdata'] - $devicequerydata[1]['mindata'], 2))/(round($devicequerydata[2]['maxdata'] - $devicequerydata[2]['mindata'], 2));

            $html .= "<table border='1' style='border-color:#f1f1f1;font-family:Arial;font-size:14px;text-align:center' cellpadding='5' cellspacing='0'>
            <tbody>    
            <tr>
                <td colspan=' 6' style='font-size:17px;font-weight:bold;text-align:center'>" . $deviceval['deviceName'] . "<br><span style='color:red'>Average PF of the day : </span>" .  round($averagepf,3)  . "</td>
            </tr>
            <tr style='font-weight:bold;background:#f1f1f1'>
                <td style='text-align:center'>Electricity Type</td>
                <td style='text-align:center'>Reading on 0:00 hrs</td>
                <td style='text-align:center'>Reading on 23:59 hrs</td>
                <td style='text-align:center'>Total Units</td>
                <td style='line-height:15px;text-align:center'>Unit Price <span style='font-size:18px'>₹</span></td>
                <td style='line-height:15px;text-align:center'>Total Cost <span style='font-size:18px'>₹</span></td>
            </tr>";
          }
          if (count($devicequerydata) > 1) {
            $html .= "<tr>
                <td style='text-align:center'>EB KWh</td>
                <td style='text-align:center'>" . $devicequerydata[1]['mindata'] . "</td>
                <td style='text-align:center'>" . $devicequerydata[1]['maxdata'] . "</td>
                <td style='text-align:center'>" . round($devicequerydata[1]['maxdata'] - $devicequerydata[1]['mindata'], 2) . "</td>
                <td style='text-align:center'>6.65</td>
                <td style='font-weight:bold;text-align:center'>" . round((($devicequerydata[1]['maxdata'] - $devicequerydata[1]['mindata']) * 6.65), 2) . "</td>
            </tr>";
          }

          if (count($devicequerydata) > 2) {
            $html .= "<tr>
                <td style='text-align:center'>EB KVAh</td>
                <td style='text-align:center'>" . $devicequerydata[2]['mindata'] . "</td>
                <td style='text-align:center'>" . $devicequerydata[2]['maxdata'] . "</td>
                <td style='text-align:center'>" . round($devicequerydata[2]['maxdata'] - $devicequerydata[1]['mindata'], 2) . "</td>
                <td style='text-align:center'>6.65</td>
                <td style='font-weight:bold;text-align:center'>" . round((($devicequerydata[2]['maxdata'] - $devicequerydata[2]['mindata']) * 6.65), 2) . "</td>
            </tr>
            <tr>
                <td style='text-align:center'>DG KWH</td>
                <td style='text-align:center'>0.00</td>
                <td style='text-align:center'>0.00</td>
                <td style='text-align:center'>0.00</td>
                <td style='text-align:center'>15.00</td>
                <td style='font-weight:bold;text-align:center'>0.00</td>
            </tr>
            <tr style='font-weight:bold'>
                <td colspan=' 5' style='text-align:right'>Total Bill (EBKVAh) : </td>
                <td style='text-align:center'>" . round((($devicequerydata[2]['maxdata'] - $devicequerydata[2]['mindata']) * 6.65), 2) . "</td>
            </tr>
            </tbody></table><br>";
          }
        }
        $html .= '</td></table></body></html>';


        require_once('../../vendor/autoload.php');

        $config = SendinBlue\Client\Configuration::getDefaultConfiguration()->setApiKey('api-key', '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');

        $apiInstance = new SendinBlue\Client\Api\TransactionalEmailsApi(
          new GuzzleHttp\Client(),
          $config
        );
        $sendSmtpEmail = new \SendinBlue\Client\Model\SendSmtpEmail();
        $emailarr=explode(",",$emailid);
    for($i=0;$i< count($emailarr);$i++){
        $useremail=$emailarr[$i];
        $sendSmtpEmail['subject'] = 'Auto Report mail from Trinity Energy.';
        $sendSmtpEmail['htmlContent'] = $html;
        $sendSmtpEmail['sender'] = array('name' => 'Trinity Energy', 'email' => 'emon@trinityenergy.co.in');
        $sendSmtpEmail['to'] = array(
          array('email' => $useremail, 'name' => 'Hi User')
        );
        $sendSmtpEmail['replyTo'] = array('email' => 'emon@trinityenergy.co.in', 'name' => 'Trinity Energy');
        $sendSmtpEmail['headers'] = array('Some-Custom-Name' => 'unique-id-1234');
        $sendSmtpEmail['params'] = array('parameter' => 'My param value', 'subject' => 'Auto Report email');

        try {
          $result = $apiInstance->sendTransacEmail($sendSmtpEmail);

          $response["error"] = 0;
          $response["successful"] = 1;
          $response["message"] = "Mail send successfully";
        } catch (Exception $e) {
          $response["error"] = 1;
          $response["successful"] = 0;
          $response["message"] = $e->getMessage();
        }
      }
      } else {
        $response["error"] = 1;
        $response["successful"] = 0;
        $response["message"] = "Time not match for sending mail";
      }
    }


    return $response;

  }


  public function actionGetalerts()
  {

    $AlertDateTime = date('Y-m-d');

    $sql_selectrtd = "select * from Alert where UserID=1 order by AlertDateTime desc limit 0,100";
    $resrtdLists = Yii::$app->db->createCommand($sql_selectrtd)->queryall();

    if (count($resrtdLists) > 0) {
      $response["error"] = 0;
      $response["successful"] = 1;
      $response["data"] = $resrtdLists;
    } else {
      $response["error"] = 0;
      $response["successful"] = 1;
      $response["data"] = [];
    }
    //$response["deviceData"] = $userdata;
    return $response;
  }

  /*public function actionSenddailyreport() 
  {
  $html='<html><body><table><td colspan="2" style="padding:10px 0"><h2 style="font-size:20px;padding:0;margin:20px 0 0 0;font-weight:bold;font-family:Arial">Daily Consumption report for <span style="color:red">02 Jul, 2023</span> - St. Andrews Institute of Technology &amp; Management</h2><br>
  <table border="1" style="border-color:#f1f1f1;font-family:Arial;font-size:14px;text-align:center" cellpadding=" 5" cellspacing=" 0">
  <tbody><tr>
  <td colspan=" 6" style="font-size:17px;font-weight:bold;text-align:center">MAIN INCOMER<br><span style="color:red">Average PF of the day : </span>0.986</td>
  </tr>
  <tr style="font-weight:bold;background:#f1f1f1">
  <td style="text-align:center">Electricity Type</td>
  <td style="text-align:center">Reading on 0:00 hrs</td>
  <td style="text-align:center">Reading on 23:59 hrs</td>
  <td style="text-align:center">Total Units</td>
  <td style="line-height:15px;text-align:center">Unit Price <span style="font-size:18px">₹</span></td>
  <td style="line-height:15px;text-align:center">Total Cost <span style="font-size:18px">₹</span></td>
  </tr>
  <tr>
  <td style="text-align:center">EB KWh</td>
  <td style="text-align:center">399761.63</td>
  <td style="text-align:center">401715.12</td>
  <td style="text-align:center">1953.49</td>
  <td style="text-align:center">6.65</td>
  <td style="font-weight:bold;text-align:center">12990.71</td>
  </tr>
  <tr>
  <td style="text-align:center">EB KVAh</td>
  <td style="text-align:center">404484.99</td>
  <td style="text-align:center">406466.18</td>
  <td style="text-align:center">1981.19</td>
  <td style="text-align:center">6.65</td>
  <td style="font-weight:bold;text-align:center">13174.91</td>
  </tr>
  <tr>
  <td style="text-align:center">DG KWH</td>
  <td style="text-align:center">0.00</td>
  <td style="text-align:center">0.00</td>
  <td style="text-align:center">0.00</td>
  <td style="text-align:center">15.00</td>
  <td style="font-weight:bold;text-align:center">0.00</td>
  </tr>
  <tr style="font-weight:bold">
  <td colspan=" 5" style="text-align:right">Total Bill ( DG + EBKVAh ) : </td>
  <td style="text-align:center">13174.91</td>
  </tr>
  </tbody></table><br>
  </td></table></body></html>';
  /*$emailid='hashimjasim@gmail.com';
  require_once('../../vendor/autoload.php');
  $config = SendinBlue\Client\Configuration::getDefaultConfiguration()->setApiKey('api-key', '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');
  $apiInstance = new SendinBlue\Client\Api\TransactionalEmailsApi(
  new GuzzleHttp\Client(),
  $config
  );
  $sendSmtpEmail = new \SendinBlue\Client\Model\SendSmtpEmail();
  $sendSmtpEmail['subject'] = 'Auto Report mail from Trinity Energy.';
  $sendSmtpEmail['htmlContent'] = $html;
  $sendSmtpEmail['sender'] = array('name' => 'Trinity Energy', 'email' => 'emon@trinityenergy.co.in');
  $sendSmtpEmail['to'] = array(
  array('email' => $emailid, 'name' => 'Hi User')
  );
  $sendSmtpEmail['replyTo'] = array('email' => 'emon@trinityenergy.co.in', 'name' => 'John Doe');
  $sendSmtpEmail['headers'] = array('Some-Custom-Name' => 'unique-id-1234');
  $sendSmtpEmail['params'] = array('parameter' => 'My param value', 'subject' => 'Auto Report email');
  try {
  $result = $apiInstance->sendTransacEmail($sendSmtpEmail);
  echo 'Email send successfully';
  } catch (Exception $e) {
  echo 'Exception when calling TransactionalEmailsApi->sendTransacEmail: ', $e->getMessage(), PHP_EOL;
  }*/

  /* $response["error"] = 0;
  $response["successful"] = 1; 
  $response["data"] = $resrtdLists;                       
  //$response["deviceData"] = $userdata;
  return $response;
  }*/


  public function actionGetgaugedialdata()
  {

    $querydevice = "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,d.deviceMasterID FROM device d join gateway g join deviceDataDaily dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and d.isLive=1";
    $devicedata = Yii::$app->db->createCommand($querydevice)->queryall();

    if (isset($_REQUEST['deviceID']) && $_REQUEST['deviceID'] != 0) {
      $res = explode("_", $_REQUEST['deviceID']);
      $deviceID = $res[0];
      $gatewayID = $res[1];
      $deviceMasterID = $res[2];
    } else {
      if (count($devicedata) > 0) {
        $gatewayID = $devicedata[0]['gatewayID'];
        $deviceID = $devicedata[0]['modBusID'];
        $deviceMasterID = $devicedata[0]['deviceMasterID'];
      } else {
        $gatewayID = 0;
        $deviceID = 0;
        $deviceMasterID = 0;
      }
    }

    $cond = ' where dmma.deviceMasterID =' . $deviceMasterID;

    $queryall = "SELECT distinct(mm.mapMasterCode),mm.mapMasterID,mm.mapMasterName,dmma.deviceMapMastershowonDashboard,dmma.deviceMapMasterAdminID,dmma.gaugeDialSettingID FROM `deviceMapMasterAdmin` as dmma join mapMaster as mm on dmma.mapMasterID=mm.mapMasterID $cond and dmma.deviceMapMastershowonDashboard=1 order by mm.mapMasterID asc limit 0,5";

    $connection = Yii::$app->getDb();
    $command1 = $connection->createCommand($queryall);
    $datamapmaster = $command1->queryAll();
    $dialdata = array();
    $mapmasterarr = array('PF System', 'KVA System', 'KWH', 'KVAH', '', '');
    foreach ($datamapmaster as $mmdata) {
      $mapmasterIDs = $mmdata['mapMasterID'];
      $mapMasterName = $mmdata['mapMasterName'];
      //$gaugeDialSettingID=$mmdata['gaugeDialSettingID'];
      //$mmarr[]=$mapMasterName;
      $sql_selectmmid = "select gaugeDialSettingID from deviceMapMasterAdmin where mapMasterID=$mapmasterIDs";
      $resmmid = Yii::$app->db->createCommand($sql_selectmmid)->queryall();
      $gaugeDialSettingID = $resmmid[0]['gaugeDialSettingID'];
      $sql_selectgdsetting = "select * from gaugeDialSetting where gaugeDialSettingID=$gaugeDialSettingID";
      $resgaugedialsetting = Yii::$app->db->createCommand($sql_selectgdsetting)->queryall();
      //}
      //$mapmasterIDs=implode(",",$mapmasterIDs);

      $sql_selectgd = "select * from deviceDataDaily where deviceID=$deviceID and gatewayID=$gatewayID and mapMasterID =$mapmasterIDs order by timeStamp desc limit 0,1";
      $resgaugedial = Yii::$app->db->createCommand($sql_selectgd)->queryall();
      if (count($resgaugedial) > 0)
        $deData = $resgaugedial[0]['data'];
      else
        $deData = 0;
      if (count($resgaugedialsetting) > 0) {
        $dialdata[] = array(
          "mapMasterName" => $mapMasterName,
          "deData" => $deData,
          "gaugeDialSettingMaxValue" => $resgaugedialsetting[0]['gaugeDialSettingMaxValue']
          ,
          "gaugeDialSettingMinValue" => $resgaugedialsetting[0]['gaugeDialSettingMinValue']
          ,
          "gaugeDialSettingGreenMarkStarts" => $resgaugedialsetting[0]['gaugeDialSettingGreenMarkStarts']
          ,
          "gaugeDialSettingGreenMarkEnd" => $resgaugedialsetting[0]['gaugeDialSettingGreenMarkEnd']
          ,
          "gaugeDialSettingRedMarkStarts" => $resgaugedialsetting[0]['gaugeDialSettingRedMarkStarts']
          ,
          "gaugeDialSettingRedMarkEnd" => $resgaugedialsetting[0]['gaugeDialSettingRedMarkEnd']
        );
      } else {
        $dialdata[] = array(
          "mapMasterName" => $mapMasterName,
          "deData" => $deData,
          "gaugeDialSettingMaxValue" => 300
          ,
          "gaugeDialSettingMinValue" => 0
          ,
          "gaugeDialSettingGreenMarkStarts" => 150
          ,
          "gaugeDialSettingGreenMarkEnd" => 200
          ,
          "gaugeDialSettingRedMarkStarts" => 200
          ,
          "gaugeDialSettingRedMarkEnd" => 300
        );
      }
    }

    if (count($dialdata) == 4) {
      $dialdata[] = array(
        "mapMasterName" => 'N/A',
        "deData" => 0.0,
        "gaugeDialSettingMaxValue" => 300
        ,
        "gaugeDialSettingMinValue" => 0
        ,
        "gaugeDialSettingGreenMarkStarts" => 150
        ,
        "gaugeDialSettingGreenMarkEnd" => 200
        ,
        "gaugeDialSettingRedMarkStarts" => 200
        ,
        "gaugeDialSettingRedMarkEnd" => 300
      );
    } else if (count($dialdata) == 3) {
      $dialdata[] = array(
        "mapMasterName" => 'N/A',
        "deData" => 0.0,
        "gaugeDialSettingMaxValue" => 300
        ,
        "gaugeDialSettingMinValue" => 0
        ,
        "gaugeDialSettingGreenMarkStarts" => 150
        ,
        "gaugeDialSettingGreenMarkEnd" => 200
        ,
        "gaugeDialSettingRedMarkStarts" => 200
        ,
        "gaugeDialSettingRedMarkEnd" => 300
      );
      $dialdata[] = array(
        "mapMasterName" => 'N/A',
        "deData" => 0.0,
        "gaugeDialSettingMaxValue" => 300
        ,
        "gaugeDialSettingMinValue" => 0
        ,
        "gaugeDialSettingGreenMarkStarts" => 150
        ,
        "gaugeDialSettingGreenMarkEnd" => 200
        ,
        "gaugeDialSettingRedMarkStarts" => 200
        ,
        "gaugeDialSettingRedMarkEnd" => 300
      );
    }
    //print_r($dialdata);
    //die();
    $response["error"] = 0;
    $response["successful"] = 1;
    $response["data"] = $dialdata;
    //$response["data1"] = $datamapmaster;                       
    //$response["deviceData"] = $userdata;
    return $response;
  }


  public function actionGetsinglechartdata()
  {

    $todayTime = date("Ymdhi");
    $querydevice = "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID FROM device d join gateway g join deviceData dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID";
    $devicedata = Yii::$app->db->createCommand($querydevice)->queryall();

    if (!isset($_REQUEST['deviceid'])) {
      $deviceid = $devicedata[0]['modBusID'];
      if (isset($_REQUEST['mmid']) && $_REQUEST['mmid'] != '')
        $mmid = $_REQUEST['mmid'];
      else
        $mmid = 4;
      $gatewayid = $devicedata[0]['gatewayID'];
      $startTime = date("Y-m-d H:i:s");
      $to1 = date('YmdHis', strtotime('+6 hours', strtotime($startTime)));

      $from1 = date('YmdHis', strtotime('-18 hours', strtotime($startTime)));
    } else {
      //echo'deviceid='.$deviceid=$_REQUEST['deviceid'];
      $mmid = $_REQUEST['mmid'];
      $deviceid = $_REQUEST['deviceid'];
      $gatewayid = $_REQUEST['gatewayID'];
      $daterange1 = $_REQUEST['daterange'];
      $daterange = explode('-', $daterange1);
      $from = $daterange[0];
      $patern = array("/", ":", " ");
      $from1 = str_replace($patern, "", $from);
      $to = $daterange[1];
      $to1 = str_replace($patern, "", $to);
    }
    //die();
    $querymm = "SELECT mapMasterName FROM mapMaster where mapMasterID=$mmid";
    $connection = Yii::$app->getDb();
    $command = $connection->createCommand($querymm);
    $mapmaster = $command->queryAll();
    //print_r($mapmaster);
    //die($querymm);
    if (count($mapmaster) > 0)
      $mapMasterName1 = $mapmaster[0]['mapMasterName'];
    else
      $mapMasterName1 = 'KW System';

    /* $sql_selectrtd = "select distinct(timeStamp),data from deviceData where timeStamp between '".$from1."' and '".$to1."' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid order by timeStamp desc";
    //die($sql_selectrtd);    
    $resrtdLists= Yii::$app->db->createCommand($sql_selectrtd)->queryall();
    $count_resrtdLists= count($resrtdLists);*/
    //print_r($resrtdLists[10]['data']);
    //die();
    // calculation for comparison report//

    //if($mmid==4 || $mmid==5){
    $startTime1 = date("Y-m-d");

    $todayfrom1 = date('Ymd') . '000000';
    $todayto1 = date('Ymd') . '030000';
    $sql_selectt1 = "select max(data) as data from deviceDataDaily where timeStamp between '" . $todayfrom1 . "' and '" . $todayto1 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisont1 = Yii::$app->db->createCommand($sql_selectt1)->queryall();
    if (count($comparisont1) > 0)
      $today1 = $comparisont1[0]['data'];
    else
      $today1 = 00.00;
    if ($today1 == NULL)
      $today1 = 0.0;

    $todayfrom2 = date('Ymd') . '030000';
    $todayto2 = date('Ymd') . '060000';
    $sql_selectt2 = "select  max(data) as data from deviceDataDaily where timeStamp between '" . $todayfrom2 . "' and '" . $todayto2 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisont2 = Yii::$app->db->createCommand($sql_selectt2)->queryall();
    if (count($comparisont2) > 0)
      $today2 = $comparisont2[0]['data'];
    else
      $today2 = 00.00;
    if ($today2 == NULL)
      $today2 = 0.0;

    $todayfrom3 = date('Ymd') . '060000';
    $todayto3 = date('Ymd') . '090000';
    $sql_selectt3 = "select   max(data) as data from deviceDataDaily where timeStamp between '" . $todayfrom3 . "' and '" . $todayto3 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisont3 = Yii::$app->db->createCommand($sql_selectt3)->queryall();
    if (count($comparisont3) > 0)
      $today3 = $comparisont3[0]['data'];
    else
      $today3 = 00.00;
    if ($today3 == NULL)
      $today3 = 0.0;

    $todayfrom4 = date('Ymd') . '090000';
    $todayto4 = date('Ymd') . '120000';
    $sql_selectt4 = "select   max(data) as data from deviceDataDaily where timeStamp between '" . $todayfrom4 . "' and '" . $todayto4 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisont4 = Yii::$app->db->createCommand($sql_selectt4)->queryall();
    if (count($comparisont4) > 0)
      $today4 = $comparisont4[0]['data'];
    else
      $today4 = 00.00;
    if ($today4 == NULL)
      $today4 = 0.0;

    $todayfrom5 = date('Ymd') . '120000';
    $todayto5 = date('Ymd') . '150000';
    $sql_selectt5 = "select   max(data) as data from deviceDataDaily where timeStamp between '" . $todayfrom5 . "' and '" . $todayto5 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisont5 = Yii::$app->db->createCommand($sql_selectt5)->queryall();
    if (count($comparisont5) > 0)
      $today5 = $comparisont5[0]['data'];
    else
      $today5 = 00.00;
    if ($today5 == NULL)
      $today5 = 0.0;

    $todayfrom6 = date('Ymd') . '150000';
    $todayto6 = date('Ymd') . '180000';
    $sql_selectt6 = "select  max(data) as data  from deviceDataDaily where timeStamp between '" . $todayfrom6 . "' and '" . $todayto6 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisont6 = Yii::$app->db->createCommand($sql_selectt6)->queryall();
    if (count($comparisont6) > 0)
      $today6 = $comparisont6[0]['data'];
    else
      $today6 = 00.00;
    if ($today6 == NULL)
      $today6 = 0.0;

    $todayfrom7 = date('Ymd') . '180000';
    $todayto7 = date('Ymd') . '210000';
    $sql_selectt7 = "select  max(data) as data  from deviceDataDaily where timeStamp between '" . $todayfrom7 . "' and '" . $todayto7 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisont7 = Yii::$app->db->createCommand($sql_selectt7)->queryall();
    if (count($comparisont7) > 0)
      $today7 = $comparisont7[0]['data'];
    else
      $today7 = 00.00;
    if ($today7 == NULL)
      $today7 = 0.0;

    $todayfrom8 = date('Ymd') . '210000';
    $todayto8 = date('Ymd') . '240000';
    $sql_selectt8 = "select  max(data) as data  from deviceDataDaily where timeStamp between '" . $todayfrom8 . "' and '" . $todayto8 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisont8 = Yii::$app->db->createCommand($sql_selectt8)->queryall();
    if (count($comparisont8) > 0)
      $today8 = $comparisont8[0]['data'];
    else
      $today8 = 00.00;
    if ($today8 == NULL)
      $today8 = 0.0;

    $yesterdayfrom1 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '000000';
    $yesterdayto1 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '030000';

    $sql_selecty1 = "select  max(data) as data  from deviceDataDaily where timeStamp between '" . $yesterdayfrom1 . "' and '" . $yesterdayto1 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisony1 = Yii::$app->db->createCommand($sql_selecty1)->queryall();
    if (count($comparisony1) > 0)
      $yesterday1 = $comparisony1[0]['data'];
    else
      $yesterday1 = 00.00;
    if ($yesterday1 == NULL)
      $yesterday1 = 0.0;

    $yesterdayfrom2 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '030000';
    $yesterdayto2 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '060000';
    $sql_selecty2 = "select max(data) as data  from deviceDataDaily where timeStamp between '" . $yesterdayfrom2 . "' and '" . $yesterdayto2 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisony2 = Yii::$app->db->createCommand($sql_selecty2)->queryall();
    if (count($comparisony2) > 0)
      $yesterday2 = $comparisony2[0]['data'];
    else
      $yesterday2 = 00.00;
    if ($yesterday2 == NULL)
      $yesterday2 = 0.0;

    $yesterdayfrom3 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '060000';
    $yesterdayto3 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '090000';
    $sql_selecty3 = "select  max(data) as data  from deviceDataDaily where timeStamp between '" . $yesterdayfrom3 . "' and '" . $yesterdayto3 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisony3 = Yii::$app->db->createCommand($sql_selecty3)->queryall();
    if (count($comparisony3) > 0)
      $yesterday3 = $comparisony3[0]['data'];
    else
      $yesterday3 = 00.00;
    if ($yesterday3 == NULL)
      $yesterday3 = 0.0;

    $yesterdayfrom4 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '090000';
    $yesterdayto4 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '120000';
    $sql_selecty4 = "select   max(data) as data  from deviceDataDaily where timeStamp between '" . $yesterdayfrom4 . "' and '" . $yesterdayto4 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisony4 = Yii::$app->db->createCommand($sql_selecty1)->queryall();
    if (count($comparisony4) > 0)
      $yesterday4 = $comparisony4[0]['data'];
    else
      $yesterday4 = 00.00;
    if ($yesterday4 == NULL)
      $yesterday4 = 0.0;

    $yesterdayfrom5 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '120000';
    $yesterdayto5 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '150000';
    $sql_selecty5 = "select  max(data) as data  from deviceDataDaily where timeStamp between '" . $yesterdayfrom5 . "' and '" . $yesterdayto5 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisony5 = Yii::$app->db->createCommand($sql_selecty5)->queryall();
    if (count($comparisony5) > 0)
      $yesterday5 = $comparisony5[0]['data'];
    else
      $yesterday5 = 00.00;
    if ($yesterday5 == NULL)
      $yesterday5 = 0.0;

    $yesterdayfrom6 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '150000';
    $yesterdayto6 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '180000';
    $sql_selecty6 = "select  max(data) as data  from deviceDataDaily where timeStamp between '" . $yesterdayfrom6 . "' and '" . $yesterdayto6 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisony6 = Yii::$app->db->createCommand($sql_selecty6)->queryall();
    if (count($comparisony6) > 0)
      $yesterday6 = $comparisony6[0]['data'];
    else
      $yesterday6 = 00.00;
    if ($yesterday6 == NULL)
      $yesterday6 = 0.0;

    $yesterdayfrom7 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '180000';
    $yesterdayto7 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '210000';
    $sql_selecty7 = "select  max(data) as data  from deviceDataDaily where timeStamp between '" . $yesterdayfrom7 . "' and '" . $yesterdayto7 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisony7 = Yii::$app->db->createCommand($sql_selecty7)->queryall();
    if (count($comparisony7) > 0)
      $yesterday7 = $comparisony7[0]['data'];
    else
      $yesterday7 = 00.00;
    if ($yesterday7 == NULL)
      $yesterday7 = 0.0;

    $yesterdayfrom8 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '210000';
    $yesterdayto8 = date('Ymd', strtotime('-24 hours', strtotime($startTime1))) . '240000';
    $sql_selecty8 = "select  max(data) as data  from deviceDataDaily where timeStamp between '" . $yesterdayfrom8 . "' and '" . $yesterdayto8 . "' and mapMasterID=$mmid and deviceID=$deviceid and gatewayID=$gatewayid";
    $comparisony8 = Yii::$app->db->createCommand($sql_selecty8)->queryall();
    if (count($comparisony8) > 0)
      $yesterday8 = $comparisony8[0]['data'];
    else
      $yesterday8 = 00.00;
    if ($yesterday8 == NULL)
      $yesterday8 = 0.0;

    $comparison_report = [
      ['hour' => '0:00 to 3:00 HRS', 'today' => $today1, 'yesterday' => $yesterday1],
      ['hour' => '3:00 to 6:00 HRS', 'today' => $today2, 'yesterday' => $yesterday2],
      ['hour' => '6:00 to 9:00 HRS', 'today' => $today3, 'yesterday' => $yesterday3],
      ['hour' => '9:00 to 12:00 HRS', 'today' => $today4, 'yesterday' => $yesterday4],
      ['hour' => '12:00 to 15:00 HRS', 'today' => $today5, 'yesterday' => $yesterday5],
      ['hour' => '15:00 to 18:00 HRS', 'today' => $today6, 'yesterday' => $yesterday6],
      ['hour' => '18:00 to 21:00 HRS', 'today' => $today7, 'yesterday' => $yesterday7],
      ['hour' => '21:00 to 24:00 HRS', 'today' => $today8, 'yesterday' => $yesterday8]
    ];
    //}else{
    //$comparison_report=[];
    //}


    $response["error"] = 0;
    $response["successful"] = 1;
    $response["data"] = ['comparison_report' => $comparison_report, 'mapMasterName' => '', 'count_resrtdLists' => ''];
    //$response["deviceData"] = $userdata;
    return $response;
  }

  public function actionGetconfig()
  {
    $request = Yii::$app->request;
    $value = $request->post();
    $boxID = !empty($value['boxID']) ? $value['boxID'] : '';
    $DC = !empty($value['dc']) ? $value['dc'] : 0;
    //if($DC==4)
    //$DC=8;
    $request_data = '{"boxID":' . $boxID . ', "DC":' . $DC . '}';
    $numOfMeters = 0;
    $measurementLists1 = array();
    $model_Config = Gateway::findOne(['gatewaySerialNumber' => $boxID]);

    $sql_selectqta = "SELECT * FROM device WHERE gatewayID=$model_Config->gatewayID order by modBusID asc";
    $resqtaLists = Yii::$app->db->createCommand($sql_selectqta)->queryall();

    //print_r($resqtaLists);
//echo'DC='.$boxID;
//die();
    if ($boxID == $model_Config->gatewaySerialNumber && $DC == 0) {

      if (count($resqtaLists) > 0) {
        foreach ($resqtaLists as $qtavalue) {
          //$id=$qtavalue['id'];
          $slaveID = $qtavalue['modBusID'];
          $timeOut = $qtavalue['timeOut'];
          $delayQueryAfterResponse = $qtavalue['delayQueryAfterResponse'];
          $addressMinusValue = $qtavalue['addressMinusValue'];
          $ipIndex0 = $qtavalue['ipIndex0'];
          $ipIndex1 = $qtavalue['ipIndex1'];
          $ipIndex2 = $qtavalue['ipIndex2'];
          $ipIndex3 = $qtavalue['ipIndex3'];
          $measurementLists1[] = array("D" => (array((int) $slaveID, (int) $timeOut, (int) $delayQueryAfterResponse, (int) $addressMinusValue, (int) $ipIndex0, (int) $ipIndex1, (int) $ipIndex2, (int) $ipIndex3)));
        }
        $numOfMeters = count($resqtaLists);
      }
      $userdata = array(
        "comMethod" => $model_Config->comMethod,
        "comURL" => $model_Config->gatewayDataURL,
        "userID" => $model_Config->userID,
        "password" => $model_Config->password,
        "dataInterval" => $model_Config->dataInterval,
        "statusInterval" => $model_Config->statusInterval,
        "baudRate" => $model_Config->baudRate,
        "lineControl" => $model_Config->lineControl,
        "numOfMeters" => $numOfMeters,
        "retryCount" => $model_Config->retryCount,
        "deviceType" => $model_Config->deviceType,
        "qtaConfig" => $measurementLists1,
        "qta" => "end"
      );
      // $response["error"] = 0;
      //$response["successful"] = 1; 
      //$response["message"] = "Device Data";                       
      //$response["deviceData"] = $userdata;
      return $userdata;
    }

    // for meters  
    if ($boxID == $model_Config->gatewaySerialNumber && $DC > 0) {

      $index = $DC - 1;

      //print_r($resqtaLists);
      if (count($resqtaLists) <= $index) {
        $response["error"] = 0;
        $response["successful"] = 1;
        $response["message"] = "Device not configured.";
        return $response;
      }

      $mbid = $resqtaLists[$index]['modBusID'];
      $sql_selectqta1 = "SELECT deviceMasterID,modBusID FROM device WHERE modBusID=$mbid and gatewayID=$model_Config->gatewayID";
      $resqtaLists1 = Yii::$app->db->createCommand($sql_selectqta1)->queryall();

      $deviceMasterID = $resqtaLists1[0]['deviceMasterID'];
      $slaveID = $resqtaLists1[0]['modBusID'];
      $sql_selectqrd = "SELECT * FROM deviceMapMasterAdmin WHERE deviceMasterID=$deviceMasterID and deviceMapMasterPullData=1 order by deviceMapMasterPort asc";
      $resqrdLists = Yii::$app->db->createCommand($sql_selectqrd)->queryall();
      if (count($resqrdLists) > 0) {
        foreach ($resqrdLists as $qrdvalue) {

          //$slaveID=$qrdvalue['deviceMasterID'];
          //if($slaveID==23)
          //$slaveID=3;

          $functionCode = 3;
          $readAddress = $qrdvalue['deviceMapMasterPort'];
          $deviceMapMasterReadSize = $qrdvalue['deviceMapMasterReadSize'];
          $numberOfRegisterAddress = count($resqrdLists);
          $queryRead[] = array("QRD" => (array((int) $slaveID, (int) $functionCode, (int) $readAddress, (int) $deviceMapMasterReadSize)));
        }
      }

      $sql_selectrtd = "SELECT dmma.deviceMasterID,dmma.deviceMapMasterMF,md.mapDataTypeSymbol
       FROM deviceMapMasterAdmin as dmma left join mapDataType as md on dmma.mapDataTypeID=md.mapDataTypeID 
       where dmma.deviceMasterID=$deviceMasterID and dmma.deviceMapMasterPullData=1 order by dmma.deviceMapMasterPort asc";
      $resrtdLists = Yii::$app->db->createCommand($sql_selectrtd)->queryall();

      if (count($resrtdLists) > 0) {
        foreach ($resrtdLists as $rtdvalue) {
          //$slaveID=$rtdvalue['deviceMasterID'];
          //if($slaveID==23)
          //$slaveID=3;

          $dataType = $rtdvalue['mapDataTypeSymbol'];
          $MF = $rtdvalue['deviceMapMasterMF'];

          $readTagConfig[] = array("RTD" => array(array("C" => array((int) $slaveID, $dataType, (int) $MF))));

        }
      }
      //sleep(10);
      $userdata = array(
        "queryRead" => $queryRead,
        "qra" => "end",
        "readTagConfig" => $readTagConfig,
        "rtc" => "end"
      );

      //$response["error"] = 0;
      //$response["successful"] = 1; 
      //$response["message"] = "Device Data";                       
      //$response["deviceData"] = $userdata;
      return $userdata;
    } else {
      $response["error"] = 0;
      $response["successful"] = 1;
      $response["message"] = "Device not configured.";
      return $response;
    }



  }


  public function actionDatareceiver()
  {
    $model_ConfigResponse = new ConfigApiResponse();
    $model_ConfigStatus = new ConfigApiStatus();


    $value = Yii::$app->request->post();
    /*$value ='{
    "B":"2011DCM0001","U":"demo",
    "P":"demo",
    "RTS":[{"D":[1,0]},{"D":[2,0]},{"D":[3,0]},{"D":[8,0]}],
    "WTS":[{"D":[0,0]},{"D":[0,0]},{"D":[0,0]},{"D":[0,0]}],
    "DSR":[0],
    "DSI":[0,0],
    "DD":[
    {"D":1,"DT":"20221226191131","P":[1.74,10524.57,10619.7]},
    {"D":2,"DT":"20221226191131","P":[1.76,1.76,5.0]}
    ]
    }';
    */
    //print_r();

    // meter data coming from modem and we are storing in table
    //die(array_key_exists('RTS',$value));
    if (array_key_exists('RTS', $value)) {

      $model_ConfigResponse->responseData = json_encode($value);
      $model_ConfigResponse->save(false);

      $value2 = json_encode($value);
      $value1 = json_decode($value2);
      //print_r($value1);
      //die();
      $boxID = $value1->B;
      $model_Config = Gateway::findOne(['gatewaySerialNumber' => $boxID]);
      //print_r($model_Config);
      
      $gatewayID = $model_Config->gatewayID;
      
      
      $sql_selectqta = "SELECT * FROM device WHERE gatewayID=$gatewayID order by modBusID asc";
      $resqtaLists = Yii::$app->db->createCommand($sql_selectqta)->queryall();

      $resvalue = $value1->DD;
      for ($i = 0; $i < count($value1->DD); $i++) {
        //$deviceID=$resqtaLists[$i]['modBusID'];
        $deviceID = $resvalue[$i]->D;
        $timeStamp = $resvalue[$i]->DT;
        $p = $resvalue[$i]->P;
        //$boxid=$resvalue[$i]->B;

        $querydmid = "select deviceMasterID,deviceID from device where modBusID=$deviceID and gatewayID=$gatewayID";
        $resmap = Yii::$app->db->createCommand($querydmid)->queryall();
        $deviceMasterID = $resmap[0]['deviceMasterID'];
        $dID = $resmap[0]['deviceID'];

        $sql_selectmapMasterID = "SELECT mapMasterID,deviceMapMasterPort FROM deviceMapMasterAdmin WHERE
       deviceMasterID=$deviceMasterID and deviceMapMasterPullData=1 order by deviceMapMasterPort asc";
        $resmapMasterID = Yii::$app->db->createCommand($sql_selectmapMasterID)->queryall();
        //echo'p='.count($p);
        //echo'<BR>';
        //echo'resmapMasterID='.count($resmapMasterID);
        //die();
        $pf = array(3, 28, 29, 30);
        //echo count($p).'-----'.count($resmapMasterID);
        //echo'<BR>';
        if (count($p) == count($resmapMasterID)) {
          for ($j = 0; $j < count($p); $j++) {
            $data1 = 0;
            $model_DeviceData = new DeviceData();
            $model_DeviceData->timeStamp = $timeStamp;
            $model_DeviceData->deviceID = $deviceID;
            $model_DeviceData->gatewayID = $gatewayID;
            $model_DeviceData->dID = $dID;
            $model_DeviceData->mapMasterID = $resmapMasterID[$j]['mapMasterID'];

            $model_DeviceDataDaily = new DeviceDataDaily();
            $model_DeviceDataDaily->timeStamp = $timeStamp;
            $model_DeviceDataDaily->deviceID = $deviceID;
            $model_DeviceDataDaily->gatewayID = $gatewayID;
            $model_DeviceDataDaily->dID = $dID;
            $model_DeviceDataDaily->mapMasterID = $resmapMasterID[$j]['mapMasterID'];

            $datavalue = $p[$j]; // PF Value
            // check increasing value of KWH, KVAH//
            $mmid = $resmapMasterID[$j]['mapMasterID'];
            $AlertDateTime = date('Y-m-d H:i:s');
            if ($mmid == 6 || $mmid == 7) {
              if ($mmid == 6)
                $mmname = 'KWH';
              else
                $mmname = 'KVAH';
              $incdec = '';
              $querycheck = "select max(data) as ddata from deviceDataDaily where deviceID=$deviceID and gatewayID=$gatewayID and mapMasterID=$mmid";
              $rescheck = Yii::$app->db->createCommand($querycheck)->queryall();
              $datakwh_kvah = $rescheck[0]['ddata'];

              if ($datakwh_kvah > $datavalue) {
                $newvalue = round((($datakwh_kvah - $datavalue) / $datakwh_kvah) * 100);
                if ($newvalue > 10)
                  $incdec = 'decreases';

              } else {
                if($datavalue >0){
                $newvalue = round((($datavalue - $datakwh_kvah) / $datavalue) * 100);
                $incdec = 'increases';
                }
              }
              $querydevice = "SELECT d.deviceName,g.gatewayName FROM device d join gateway g on d.gatewayID=g.gatewayID where d.deviceID=$deviceID and d.gatewayID=$gatewayID";
              $resdevice = Yii::$app->db->createCommand($querydevice)->queryall();
              if (count($resdevice) > 0 && $newvalue > 10) {
                $deviceName = $resdevice[0]['deviceName'];
                $gatewayName = $resdevice[0]['gatewayName'];


                $message = 'Power ' . $incdec . ' for ' . $mmname . ' at ' . $timeStamp . ' for device ' . $deviceName . ' and gateway ' . $gatewayName;
                $sqlinsert = "insert into Alert (AlertTypeID,AlertStatusTypeID,AlertDateTime,AlertMessage,AlertMessageTech,UserID,LastUpdateDateTime,AlertFkID) values(1,1,'$AlertDateTime','$message','',1,'$AlertDateTime',1)";

                Yii::$app->db->createCommand($sqlinsert)->execute();
              }

            }

            if (in_array($mmid, $pf)) {
              if ($datavalue > 2) {
                $data = $datavalue - 2;
                $data = (-1) * $data;

              } else if ($datavalue > 1.999) {
                $data = $datavalue - 1;
              } else if ($datavalue > 1) {
                $data = $datavalue - 1;
                $data = (-1) * $data;
              } else {
                $data = $datavalue;
              }
              $model_DeviceData->data = $data;
              $model_DeviceDataDaily->data = $data;
            } else {
              $model_DeviceData->data = $datavalue;
              $model_DeviceDataDaily->data = $datavalue;
            }
            $model_DeviceData->save(false);
            $model_DeviceDataDaily->save(false);
          }
        }
      }
    

    } else {

      //$model_ConfigStatus->statusData=json_encode($value);
      //$model_ConfigStatus->save(false);   


      $result = array(
        "RT" => 1,
        "RM" => "Success",
        "CM" => NULL,
        "QW" => NULL,
        "qwc" => "end",
        "DC" => NULL
      );

      $model_ConfigStatus->statusData = json_encode($result);
      $model_ConfigStatus->statusDataType = 'Server Success Response';
      $model_ConfigStatus->save(false);

    }
    //die();
    /*$result=array(
    "RT"=>1,
    "RM"=>"Success",
    "CM"=>NULL,
    "QW"=>NULL,
    "qwc"=>"end",
    "DC"=>NULL
    );*/
    // die();
    // Responce send to modem
    if (array_key_exists('RTS', $value)) {
      $model_Config = Gateway::findOne(['gatewaySerialNumber' => $boxID]);
      $number_of_meter = count($resqtaLists);
      $update_configure = $model_Config->updateConfigure;

      if ($update_configure == 1) {
        $modelconfig = Gateway::findOne(['gatewaySerialNumber' => $boxID]);
        $modelconfig->updateConfigure = 0;
        //$modelconfig->numOfMeters=$number_of_meter;
        $modelconfig->update(false);

        $result = array(
          "RT" => 5,
          "RM" => "Success",
          "CM" => NULL,
          "QW" => NULL,
          "qwc" => "end",
          "DC" => $number_of_meter
        );

        $model_ConfigStatus->statusData = json_encode($result);
        $model_ConfigStatus->statusDataType = 'Server Success Response + New Configuration';
        $model_ConfigStatus->save(false);

      } else {
        $result = array(
          "RT" => 1,
          "RM" => "Success",
          "CM" => NULL,
          "QW" => NULL,
          "qwc" => "end",
          "DC" => NULL
        );

        $model_ConfigStatus->statusData = json_encode($result);
        $model_ConfigStatus->statusDataType = 'Server Success Response';
        $model_ConfigStatus->save(false);
      }
    }
    //$response["error"] = 0;
    // $response["successful"] = 1;  
    // $response["message"] = 'configuration setup';
    return $result;
  }


  public function actionUploadmilestone()
  {
    define('UPLOAD_DIR', '/Web/JennyCraig/api/milestones/');
    $modelMilestoneImage = new MilestoneImage();
    $value = Yii::$app->request->post();

    $milestoneType = !empty($value['milestoneType']) ? $value['milestoneType'] : '';
    $milestoneImageName = !empty($value['milestoneImageName']) ? $value['milestoneImageName'] : '';
    $s3key = Yii::$app->params['s3key'];
    $s3secret = Yii::$app->params['s3secret'];

    $bucket = 'statics-jc-mobileapp-9530';
    $keyname = 'images/congrats/' . $milestoneType . '.png';
    /* $filepath should be absolute path to a file on disk */
    $s3 = S3Client::factory(
      array(
        'version' => 'latest',
        'region' => 'us-west-2',
        'credentials' => array(
          'key' => $s3key,
          'secret' => $s3secret,
        )
      )
    );

    if ($milestoneImageName != '') {
      $image_parts = explode(";base64,", $milestoneImageName);
      $image_base64 = base64_decode($image_parts[0]);
      $file = UPLOAD_DIR . $milestoneType . '.png';
      file_put_contents($file, $image_base64);

      $filepath = $file;
      $result = $s3->putObject(
        array(
          'Bucket' => $bucket,
          'Key' => $keyname,
          'SourceFile' => $filepath,
          'ACL' => 'public-read'
        )
      );


    }

    $sql_select = "select * from milestone_image where milestoneType='$milestoneType'";
    $res = Yii::$app->db->createCommand($sql_select)->queryone();

    if (!$res) {
      if ($milestoneImageName != '') {
        if ($milestoneType != '') {
          $modelMilestoneImage->milestoneImageName = $milestoneType . '.png';
          $modelMilestoneImage->milestoneType = $milestoneType;
          $modelMilestoneImage->created_at = date('Y-m-d');
          $modelMilestoneImage->save(false);
        }
        $response["error"] = 0;
        $response["successful"] = 1;
        $response["message"] = 'Saved';
        $response["imageUrl"] = "https://statics-mobileapp.jennycraig.com/images/congrats/" . $milestoneType . '.png';
      } else {
        $response["error"] = 1;
        $response["successful"] = 0;
        $response["message"] = 'Milestone not uploaded';

      }

    } else {
      $milestoneImageName = $res['milestoneImageName'];
      $response["error"] = 1;
      $response["successful"] = 0;
      $response["message"] = 'Already available';
      if ($milestoneImageName != '.png')
        $response["imageUrl"] = "https://statics-mobileapp.jennycraig.com/images/congrats/" . $milestoneImageName;

    }
    return $response;

  }


}