<?php
// This file was auto-generated from sdk-root/src/data/amp/2020-08-01/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2020-08-01', 'endpointPrefix' => 'aps', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'Amazon Prometheus Service', 'serviceId' => 'amp', 'signatureVersion' => 'v4', 'signingName' => 'aps', 'uid' => 'amp-2020-08-01', ], 'operations' => [ 'CreateAlertManagerDefinition' => [ 'name' => 'CreateAlertManagerDefinition', 'http' => [ 'method' => 'POST', 'requestUri' => '/workspaces/{workspaceId}/alertmanager/definition', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateAlertManagerDefinitionRequest', ], 'output' => [ 'shape' => 'CreateAlertManagerDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateLoggingConfiguration' => [ 'name' => 'CreateLoggingConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/workspaces/{workspaceId}/logging', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateLoggingConfigurationRequest', ], 'output' => [ 'shape' => 'CreateLoggingConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'CreateRuleGroupsNamespace' => [ 'name' => 'CreateRuleGroupsNamespace', 'http' => [ 'method' => 'POST', 'requestUri' => '/workspaces/{workspaceId}/rulegroupsnamespaces', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateRuleGroupsNamespaceRequest', ], 'output' => [ 'shape' => 'CreateRuleGroupsNamespaceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateScraper' => [ 'name' => 'CreateScraper', 'http' => [ 'method' => 'POST', 'requestUri' => '/scrapers', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateScraperRequest', ], 'output' => [ 'shape' => 'CreateScraperResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateWorkspace' => [ 'name' => 'CreateWorkspace', 'http' => [ 'method' => 'POST', 'requestUri' => '/workspaces', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateWorkspaceRequest', ], 'output' => [ 'shape' => 'CreateWorkspaceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'DeleteAlertManagerDefinition' => [ 'name' => 'DeleteAlertManagerDefinition', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/workspaces/{workspaceId}/alertmanager/definition', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteAlertManagerDefinitionRequest', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteLoggingConfiguration' => [ 'name' => 'DeleteLoggingConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/workspaces/{workspaceId}/logging', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteLoggingConfigurationRequest', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteRuleGroupsNamespace' => [ 'name' => 'DeleteRuleGroupsNamespace', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/workspaces/{workspaceId}/rulegroupsnamespaces/{name}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteRuleGroupsNamespaceRequest', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteScraper' => [ 'name' => 'DeleteScraper', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/scrapers/{scraperId}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteScraperRequest', ], 'output' => [ 'shape' => 'DeleteScraperResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteWorkspace' => [ 'name' => 'DeleteWorkspace', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/workspaces/{workspaceId}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteWorkspaceRequest', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DescribeAlertManagerDefinition' => [ 'name' => 'DescribeAlertManagerDefinition', 'http' => [ 'method' => 'GET', 'requestUri' => '/workspaces/{workspaceId}/alertmanager/definition', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeAlertManagerDefinitionRequest', ], 'output' => [ 'shape' => 'DescribeAlertManagerDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DescribeLoggingConfiguration' => [ 'name' => 'DescribeLoggingConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/workspaces/{workspaceId}/logging', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeLoggingConfigurationRequest', ], 'output' => [ 'shape' => 'DescribeLoggingConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DescribeRuleGroupsNamespace' => [ 'name' => 'DescribeRuleGroupsNamespace', 'http' => [ 'method' => 'GET', 'requestUri' => '/workspaces/{workspaceId}/rulegroupsnamespaces/{name}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeRuleGroupsNamespaceRequest', ], 'output' => [ 'shape' => 'DescribeRuleGroupsNamespaceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DescribeScraper' => [ 'name' => 'DescribeScraper', 'http' => [ 'method' => 'GET', 'requestUri' => '/scrapers/{scraperId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeScraperRequest', ], 'output' => [ 'shape' => 'DescribeScraperResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DescribeWorkspace' => [ 'name' => 'DescribeWorkspace', 'http' => [ 'method' => 'GET', 'requestUri' => '/workspaces/{workspaceId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeWorkspaceRequest', ], 'output' => [ 'shape' => 'DescribeWorkspaceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetDefaultScraperConfiguration' => [ 'name' => 'GetDefaultScraperConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/scraperconfiguration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDefaultScraperConfigurationRequest', ], 'output' => [ 'shape' => 'GetDefaultScraperConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListRuleGroupsNamespaces' => [ 'name' => 'ListRuleGroupsNamespaces', 'http' => [ 'method' => 'GET', 'requestUri' => '/workspaces/{workspaceId}/rulegroupsnamespaces', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListRuleGroupsNamespacesRequest', ], 'output' => [ 'shape' => 'ListRuleGroupsNamespacesResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListScrapers' => [ 'name' => 'ListScrapers', 'http' => [ 'method' => 'GET', 'requestUri' => '/scrapers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListScrapersRequest', ], 'output' => [ 'shape' => 'ListScrapersResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListWorkspaces' => [ 'name' => 'ListWorkspaces', 'http' => [ 'method' => 'GET', 'requestUri' => '/workspaces', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListWorkspacesRequest', ], 'output' => [ 'shape' => 'ListWorkspacesResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'PutAlertManagerDefinition' => [ 'name' => 'PutAlertManagerDefinition', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workspaces/{workspaceId}/alertmanager/definition', 'responseCode' => 202, ], 'input' => [ 'shape' => 'PutAlertManagerDefinitionRequest', ], 'output' => [ 'shape' => 'PutAlertManagerDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'PutRuleGroupsNamespace' => [ 'name' => 'PutRuleGroupsNamespace', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workspaces/{workspaceId}/rulegroupsnamespaces/{name}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'PutRuleGroupsNamespaceRequest', ], 'output' => [ 'shape' => 'PutRuleGroupsNamespaceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateLoggingConfiguration' => [ 'name' => 'UpdateLoggingConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/workspaces/{workspaceId}/logging', 'responseCode' => 202, ], 'input' => [ 'shape' => 'UpdateLoggingConfigurationRequest', ], 'output' => [ 'shape' => 'UpdateLoggingConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateWorkspaceAlias' => [ 'name' => 'UpdateWorkspaceAlias', 'http' => [ 'method' => 'POST', 'requestUri' => '/workspaces/{workspaceId}/alias', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UpdateWorkspaceAliasRequest', ], 'errors' => [ [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AlertManagerDefinitionData' => [ 'type' => 'blob', ], 'AlertManagerDefinitionDescription' => [ 'type' => 'structure', 'required' => [ 'status', 'data', 'createdAt', 'modifiedAt', ], 'members' => [ 'status' => [ 'shape' => 'AlertManagerDefinitionStatus', ], 'data' => [ 'shape' => 'AlertManagerDefinitionData', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'modifiedAt' => [ 'shape' => 'Timestamp', ], ], ], 'AlertManagerDefinitionStatus' => [ 'type' => 'structure', 'required' => [ 'statusCode', ], 'members' => [ 'statusCode' => [ 'shape' => 'AlertManagerDefinitionStatusCode', ], 'statusReason' => [ 'shape' => 'String', ], ], ], 'AlertManagerDefinitionStatusCode' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'UPDATING', 'DELETING', 'CREATION_FAILED', 'UPDATE_FAILED', ], ], 'AmpConfiguration' => [ 'type' => 'structure', 'required' => [ 'workspaceArn', ], 'members' => [ 'workspaceArn' => [ 'shape' => 'WorkspaceArn', ], ], ], 'Blob' => [ 'type' => 'blob', ], 'ClusterArn' => [ 'type' => 'string', 'pattern' => 'arn:aws[-a-z]*:eks:[-a-z0-9]+:[0-9]{12}:cluster/.+', ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'CreateAlertManagerDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'data', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'data' => [ 'shape' => 'AlertManagerDefinitionData', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], ], ], 'CreateAlertManagerDefinitionResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'AlertManagerDefinitionStatus', ], ], ], 'CreateLoggingConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'logGroupArn', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'logGroupArn' => [ 'shape' => 'LogGroupArn', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], ], ], 'CreateLoggingConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'LoggingConfigurationStatus', ], ], ], 'CreateRuleGroupsNamespaceRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'name', 'data', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'name' => [ 'shape' => 'RuleGroupsNamespaceName', ], 'data' => [ 'shape' => 'RuleGroupsNamespaceData', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateRuleGroupsNamespaceResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'arn', 'status', ], 'members' => [ 'name' => [ 'shape' => 'RuleGroupsNamespaceName', ], 'arn' => [ 'shape' => 'RuleGroupsNamespaceArn', ], 'status' => [ 'shape' => 'RuleGroupsNamespaceStatus', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateScraperRequest' => [ 'type' => 'structure', 'required' => [ 'scrapeConfiguration', 'source', 'destination', ], 'members' => [ 'alias' => [ 'shape' => 'ScraperAlias', ], 'scrapeConfiguration' => [ 'shape' => 'ScrapeConfiguration', ], 'source' => [ 'shape' => 'Source', ], 'destination' => [ 'shape' => 'Destination', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateScraperResponse' => [ 'type' => 'structure', 'required' => [ 'scraperId', 'arn', 'status', ], 'members' => [ 'scraperId' => [ 'shape' => 'ScraperId', ], 'arn' => [ 'shape' => 'ScraperArn', ], 'status' => [ 'shape' => 'ScraperStatus', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateWorkspaceRequest' => [ 'type' => 'structure', 'members' => [ 'alias' => [ 'shape' => 'WorkspaceAlias', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateWorkspaceResponse' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'arn', 'status', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', ], 'arn' => [ 'shape' => 'WorkspaceArn', ], 'status' => [ 'shape' => 'WorkspaceStatus', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'DeleteAlertManagerDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'DeleteLoggingConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'DeleteRuleGroupsNamespaceRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'name', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'name' => [ 'shape' => 'RuleGroupsNamespaceName', 'location' => 'uri', 'locationName' => 'name', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'DeleteScraperRequest' => [ 'type' => 'structure', 'required' => [ 'scraperId', ], 'members' => [ 'scraperId' => [ 'shape' => 'ScraperId', 'location' => 'uri', 'locationName' => 'scraperId', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'DeleteScraperResponse' => [ 'type' => 'structure', 'required' => [ 'scraperId', 'status', ], 'members' => [ 'scraperId' => [ 'shape' => 'ScraperId', ], 'status' => [ 'shape' => 'ScraperStatus', ], ], ], 'DeleteWorkspaceRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'DescribeAlertManagerDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], ], ], 'DescribeAlertManagerDefinitionResponse' => [ 'type' => 'structure', 'required' => [ 'alertManagerDefinition', ], 'members' => [ 'alertManagerDefinition' => [ 'shape' => 'AlertManagerDefinitionDescription', ], ], ], 'DescribeLoggingConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], ], ], 'DescribeLoggingConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'loggingConfiguration', ], 'members' => [ 'loggingConfiguration' => [ 'shape' => 'LoggingConfigurationMetadata', ], ], ], 'DescribeRuleGroupsNamespaceRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'name', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'name' => [ 'shape' => 'RuleGroupsNamespaceName', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'DescribeRuleGroupsNamespaceResponse' => [ 'type' => 'structure', 'required' => [ 'ruleGroupsNamespace', ], 'members' => [ 'ruleGroupsNamespace' => [ 'shape' => 'RuleGroupsNamespaceDescription', ], ], ], 'DescribeScraperRequest' => [ 'type' => 'structure', 'required' => [ 'scraperId', ], 'members' => [ 'scraperId' => [ 'shape' => 'ScraperId', 'location' => 'uri', 'locationName' => 'scraperId', ], ], ], 'DescribeScraperResponse' => [ 'type' => 'structure', 'required' => [ 'scraper', ], 'members' => [ 'scraper' => [ 'shape' => 'ScraperDescription', ], ], ], 'DescribeWorkspaceRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], ], ], 'DescribeWorkspaceResponse' => [ 'type' => 'structure', 'required' => [ 'workspace', ], 'members' => [ 'workspace' => [ 'shape' => 'WorkspaceDescription', ], ], ], 'Destination' => [ 'type' => 'structure', 'members' => [ 'ampConfiguration' => [ 'shape' => 'AmpConfiguration', ], ], 'union' => true, ], 'EksConfiguration' => [ 'type' => 'structure', 'required' => [ 'clusterArn', 'subnetIds', ], 'members' => [ 'clusterArn' => [ 'shape' => 'ClusterArn', ], 'securityGroupIds' => [ 'shape' => 'SecurityGroupIds', ], 'subnetIds' => [ 'shape' => 'SubnetIds', ], ], ], 'FilterKey' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'FilterValue' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'FilterValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterValue', ], 'max' => 20, 'min' => 1, ], 'GetDefaultScraperConfigurationRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetDefaultScraperConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'configuration', ], 'members' => [ 'configuration' => [ 'shape' => 'Blob', ], ], ], 'IamRoleArn' => [ 'type' => 'string', ], 'IdempotencyToken' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[!-~]+', ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'retryAfterSeconds' => [ 'shape' => 'Integer', 'location' => 'header', 'locationName' => 'Retry-After', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'ListRuleGroupsNamespacesRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'name' => [ 'shape' => 'RuleGroupsNamespaceName', 'location' => 'querystring', 'locationName' => 'name', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'ListRuleGroupsNamespacesRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListRuleGroupsNamespacesRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'ListRuleGroupsNamespacesResponse' => [ 'type' => 'structure', 'required' => [ 'ruleGroupsNamespaces', ], 'members' => [ 'ruleGroupsNamespaces' => [ 'shape' => 'RuleGroupsNamespaceSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListScrapersRequest' => [ 'type' => 'structure', 'members' => [ 'filters' => [ 'shape' => 'ScraperFilters', 'location' => 'querystring', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'ListScrapersRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListScrapersRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'ListScrapersResponse' => [ 'type' => 'structure', 'required' => [ 'scrapers', ], 'members' => [ 'scrapers' => [ 'shape' => 'ScraperSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagMap', ], ], ], 'ListWorkspacesRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'alias' => [ 'shape' => 'WorkspaceAlias', 'location' => 'querystring', 'locationName' => 'alias', ], 'maxResults' => [ 'shape' => 'ListWorkspacesRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListWorkspacesRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'ListWorkspacesResponse' => [ 'type' => 'structure', 'required' => [ 'workspaces', ], 'members' => [ 'workspaces' => [ 'shape' => 'WorkspaceSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'LogGroupArn' => [ 'type' => 'string', 'pattern' => 'arn:aws[a-z0-9-]*:logs:[a-z0-9-]+:\\d{12}:log-group:[A-Za-z0-9\\.\\-\\_\\#/]{1,512}\\:\\*', ], 'LoggingConfigurationMetadata' => [ 'type' => 'structure', 'required' => [ 'status', 'workspace', 'logGroupArn', 'createdAt', 'modifiedAt', ], 'members' => [ 'status' => [ 'shape' => 'LoggingConfigurationStatus', ], 'workspace' => [ 'shape' => 'WorkspaceId', ], 'logGroupArn' => [ 'shape' => 'LogGroupArn', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'modifiedAt' => [ 'shape' => 'Timestamp', ], ], ], 'LoggingConfigurationStatus' => [ 'type' => 'structure', 'required' => [ 'statusCode', ], 'members' => [ 'statusCode' => [ 'shape' => 'LoggingConfigurationStatusCode', ], 'statusReason' => [ 'shape' => 'String', ], ], ], 'LoggingConfigurationStatusCode' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'UPDATING', 'DELETING', 'CREATION_FAILED', 'UPDATE_FAILED', ], ], 'PaginationToken' => [ 'type' => 'string', 'max' => 1000, 'min' => 0, ], 'PutAlertManagerDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'data', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'data' => [ 'shape' => 'AlertManagerDefinitionData', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], ], ], 'PutAlertManagerDefinitionResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'AlertManagerDefinitionStatus', ], ], ], 'PutRuleGroupsNamespaceRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'name', 'data', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'name' => [ 'shape' => 'RuleGroupsNamespaceName', 'location' => 'uri', 'locationName' => 'name', ], 'data' => [ 'shape' => 'RuleGroupsNamespaceData', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], ], ], 'PutRuleGroupsNamespaceResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'arn', 'status', ], 'members' => [ 'name' => [ 'shape' => 'RuleGroupsNamespaceName', ], 'arn' => [ 'shape' => 'RuleGroupsNamespaceArn', ], 'status' => [ 'shape' => 'RuleGroupsNamespaceStatus', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'RuleGroupsNamespaceArn' => [ 'type' => 'string', ], 'RuleGroupsNamespaceData' => [ 'type' => 'blob', ], 'RuleGroupsNamespaceDescription' => [ 'type' => 'structure', 'required' => [ 'arn', 'name', 'status', 'data', 'createdAt', 'modifiedAt', ], 'members' => [ 'arn' => [ 'shape' => 'RuleGroupsNamespaceArn', ], 'name' => [ 'shape' => 'RuleGroupsNamespaceName', ], 'status' => [ 'shape' => 'RuleGroupsNamespaceStatus', ], 'data' => [ 'shape' => 'RuleGroupsNamespaceData', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'modifiedAt' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'RuleGroupsNamespaceName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '.*[0-9A-Za-z][-.0-9A-Z_a-z]*.*', ], 'RuleGroupsNamespaceStatus' => [ 'type' => 'structure', 'required' => [ 'statusCode', ], 'members' => [ 'statusCode' => [ 'shape' => 'RuleGroupsNamespaceStatusCode', ], 'statusReason' => [ 'shape' => 'String', ], ], ], 'RuleGroupsNamespaceStatusCode' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'UPDATING', 'DELETING', 'CREATION_FAILED', 'UPDATE_FAILED', ], ], 'RuleGroupsNamespaceSummary' => [ 'type' => 'structure', 'required' => [ 'arn', 'name', 'status', 'createdAt', 'modifiedAt', ], 'members' => [ 'arn' => [ 'shape' => 'RuleGroupsNamespaceArn', ], 'name' => [ 'shape' => 'RuleGroupsNamespaceName', ], 'status' => [ 'shape' => 'RuleGroupsNamespaceStatus', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'modifiedAt' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'RuleGroupsNamespaceSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RuleGroupsNamespaceSummary', ], ], 'ScrapeConfiguration' => [ 'type' => 'structure', 'members' => [ 'configurationBlob' => [ 'shape' => 'Blob', ], ], 'union' => true, ], 'ScraperAlias' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '[0-9A-Za-z][-.0-9A-Z_a-z]*', ], 'ScraperArn' => [ 'type' => 'string', ], 'ScraperDescription' => [ 'type' => 'structure', 'required' => [ 'scraperId', 'arn', 'roleArn', 'status', 'createdAt', 'lastModifiedAt', 'scrapeConfiguration', 'source', 'destination', ], 'members' => [ 'alias' => [ 'shape' => 'ScraperAlias', ], 'scraperId' => [ 'shape' => 'ScraperId', ], 'arn' => [ 'shape' => 'ScraperArn', ], 'roleArn' => [ 'shape' => 'IamRoleArn', ], 'status' => [ 'shape' => 'ScraperStatus', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastModifiedAt' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagMap', ], 'statusReason' => [ 'shape' => 'StatusReason', ], 'scrapeConfiguration' => [ 'shape' => 'ScrapeConfiguration', ], 'source' => [ 'shape' => 'Source', ], 'destination' => [ 'shape' => 'Destination', ], ], ], 'ScraperFilters' => [ 'type' => 'map', 'key' => [ 'shape' => 'FilterKey', ], 'value' => [ 'shape' => 'FilterValues', ], 'max' => 4, 'min' => 1, ], 'ScraperId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[0-9A-Za-z][-.0-9A-Z_a-z]*', ], 'ScraperStatus' => [ 'type' => 'structure', 'required' => [ 'statusCode', ], 'members' => [ 'statusCode' => [ 'shape' => 'ScraperStatusCode', ], ], ], 'ScraperStatusCode' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'DELETING', 'CREATION_FAILED', 'DELETION_FAILED', ], ], 'ScraperSummary' => [ 'type' => 'structure', 'required' => [ 'scraperId', 'arn', 'roleArn', 'status', 'createdAt', 'lastModifiedAt', 'source', 'destination', ], 'members' => [ 'alias' => [ 'shape' => 'ScraperAlias', ], 'scraperId' => [ 'shape' => 'ScraperId', ], 'arn' => [ 'shape' => 'ScraperArn', ], 'roleArn' => [ 'shape' => 'IamRoleArn', ], 'status' => [ 'shape' => 'ScraperStatus', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastModifiedAt' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagMap', ], 'statusReason' => [ 'shape' => 'StatusReason', ], 'source' => [ 'shape' => 'Source', ], 'destination' => [ 'shape' => 'Destination', ], ], ], 'ScraperSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ScraperSummary', ], ], 'SecurityGroupId' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => 'sg-[0-9a-z]+', ], 'SecurityGroupIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupId', ], 'max' => 5, 'min' => 1, ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', 'serviceCode', 'quotaCode', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], 'serviceCode' => [ 'shape' => 'String', ], 'quotaCode' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'Source' => [ 'type' => 'structure', 'members' => [ 'eksConfiguration' => [ 'shape' => 'EksConfiguration', ], ], 'union' => true, ], 'StatusReason' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'String' => [ 'type' => 'string', ], 'SubnetId' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => 'subnet-[0-9a-z]+', ], 'SubnetIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubnetId', ], 'max' => 5, 'min' => 1, ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)', ], 'TagKeys' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], ], 'TagMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 0, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)', ], 'ThrottlingException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'serviceCode' => [ 'shape' => 'String', ], 'quotaCode' => [ 'shape' => 'String', ], 'retryAfterSeconds' => [ 'shape' => 'Integer', 'location' => 'header', 'locationName' => 'Retry-After', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => false, ], ], 'Timestamp' => [ 'type' => 'timestamp', ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeys', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateLoggingConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'logGroupArn', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'logGroupArn' => [ 'shape' => 'LogGroupArn', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], ], ], 'UpdateLoggingConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'LoggingConfigurationStatus', ], ], ], 'UpdateWorkspaceAliasRequest' => [ 'type' => 'structure', 'required' => [ 'workspaceId', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', 'location' => 'uri', 'locationName' => 'workspaceId', ], 'alias' => [ 'shape' => 'WorkspaceAlias', ], 'clientToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], ], ], 'Uri' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', 'reason', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'reason' => [ 'shape' => 'ValidationExceptionReason', ], 'fieldList' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'name', 'message', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'ValidationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'UNKNOWN_OPERATION', 'CANNOT_PARSE', 'FIELD_VALIDATION_FAILED', 'OTHER', ], ], 'WorkspaceAlias' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'WorkspaceArn' => [ 'type' => 'string', 'pattern' => 'arn:aws[-a-z]*:aps:[-a-z0-9]+:[0-9]{12}:workspace/.+', ], 'WorkspaceDescription' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'arn', 'status', 'createdAt', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', ], 'alias' => [ 'shape' => 'WorkspaceAlias', ], 'arn' => [ 'shape' => 'WorkspaceArn', ], 'status' => [ 'shape' => 'WorkspaceStatus', ], 'prometheusEndpoint' => [ 'shape' => 'Uri', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'WorkspaceId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '.*[0-9A-Za-z][-.0-9A-Z_a-z]*.*', ], 'WorkspaceStatus' => [ 'type' => 'structure', 'required' => [ 'statusCode', ], 'members' => [ 'statusCode' => [ 'shape' => 'WorkspaceStatusCode', ], ], ], 'WorkspaceStatusCode' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'UPDATING', 'DELETING', 'CREATION_FAILED', ], ], 'WorkspaceSummary' => [ 'type' => 'structure', 'required' => [ 'workspaceId', 'arn', 'status', 'createdAt', ], 'members' => [ 'workspaceId' => [ 'shape' => 'WorkspaceId', ], 'alias' => [ 'shape' => 'WorkspaceAlias', ], 'arn' => [ 'shape' => 'WorkspaceArn', ], 'status' => [ 'shape' => 'WorkspaceStatus', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'WorkspaceSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'WorkspaceSummary', ], ], ],];
