<?php
namespace Codeception\Lib\Connector\Laravel5;

use Exception;

/**
 * Class ExceptionHandlerDecorator
 *
 * @package Codeception\Lib\Connector\Laravel5
 */
class ExceptionHandlerDecorator
{
    /**
     * @var ExceptionHandlerContract
     */
    private $laravelExceptionHandler;

    /**
     * @var boolean
     */
    private $exceptionHandlingDisabled = true;

    /**
     * ExceptionHandlerDecorator constructor.
     *
     * @param object $laravelExceptionHandler
     */
    public function __construct($laravelExceptionHandler)
    {
        $this->laravelExceptionHandler = $laravelExceptionHandler;
    }

    /**
     * @param boolean $exceptionHandlingDisabled
     */
    public function exceptionHandlingDisabled($exceptionHandlingDisabled)
    {
        $this->exceptionHandlingDisabled = $exceptionHandlingDisabled;
    }

    /**
     * @param $request
     * @param Exception $e
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws Exception
     */
    public function render($request, Exception $e)
    {
        $response = $this->laravelExceptionHandler->render($request, $e);

        if ($this->exceptionHandlingDisabled &&
            strpos($response->getContent(), '<div id="sf-resetcontent" class="sf-reset">') !== false
        ) {
            // If content was generated by the \Symfony\Component\Debug\ExceptionHandler class
            // the Laravel application could not handle the exception,
            // so re-throw this exception if the Codeception user disabled Laravel's exception handling.
            throw $e;
        }

        return $response;
    }

    /**
     * @param string $method
     * @param array $args
     * @return mixed
     */
    public function __call($method, $args)
    {
        return call_user_func_array(array($this->laravelExceptionHandler, $method), $args);
    }
}
